BEM.DOM.decl({
    block: 'b-statistic-filters-editor',
    elem: 'dropdown',
    modName: 'type',
    modVal: 'filters-chooser'
}, {

    onSetMod: {
        js: function() {
            this.getChooser()
                .on('change', this._onChooserChange, this)
                .getSelected().map(function(item) {
                    this.getChooser().disable(item.name);
                }, this);
        }
    },

    /**
     * Возвращает блок со списком фильтров
     * @returns {BEM}
     */
    getChooser: function() {
        return this._chooser || (this._chooser = this.findBlockInside('filters-chooser', 'b-chooser'));
    },

    /**
     * Скрывает popup, добавляет новый фильтр и скрывает его от поиска
     * @param {Event} e
     * @param {Object} data
     *  @param {String} data.name - имя фильтра
     *  @param {Boolean} data.selected - выбран/не выбран
     *  @param {Object} [data.extraParams] - дополнительные параметры
     * @private
     */
    _onChooserChange: function(e, data) {
        var searchValue = this.getChooser().getInput().val();

        if (data.selected) {
            this.getPopup().hide();
            this.getParent().addFilter(data);
            this.getChooser().disable(data.name);
        }

        // skywhale: DIRECT-47064
        this.getChooser().search('');
        this.getChooser().search(searchValue);

        this._checkSelectedCount();
    },

    /**
     * Возвращает блок button
     * @returns {BEM}
     */
    _getSwitcher: function() {
        return this._switcher || (this._switcher = this.findBlockInside('filters-chooser-switcher', 'button'));
    },

    /**
     * Дизейблит/раздизейбливает button «Добавить фильтр»
     * @returns {BEM}
     * @private
     */
    _checkSelectedCount: function() {
        var isAllSelected = this.getChooser().getAll().every(function(item) {
            return item.selected;
        });

        this._getSwitcher().setMod('disabled', isAllSelected ? 'yes' : '');

        return this;
    },

    /**
     * Делает фильтр выбранным и скрывает его от поиска
     * @param {String} filterName - имя фильтра
     * @returns {BEM}
     */
    checkFilter: function(filterName) {
        this.getChooser()
            .check(filterName)
            .disable(filterName);

        return this;
    },

    /**
     * Делает фильтр не выбранным и открывает его для поиска
     * @param {String} filterName - имя фильтра
     * @returns {BEM}
     */
    uncheckFilter: function(filterName) {
        this.getChooser()
            .enable(filterName)
            .uncheck(filterName);

        return this;
    }

}, {

    live: function() {

        this.__base.apply(this, arguments);

        this.liveInitOnBlockInsideEvent('show', 'dropdown');

    }

});
