BEM.DOM.decl({
    block: 'b-statistic-filters-editor',
    elem: 'dropdown',
    modName: 'type',
    modVal: 'save-template'
}, {

    /**
     * Возвращает блок сохраняющий шаблон
     * @returns {BEM}
     */
    getTemplateSaving: function() {
        return this._templateSaving || (this._templateSaving = this.findBlockOn('b-statistics-template-saving'));
    },

    /**
     * Дизейблит/раздизейбливает кнопку «Сохранить в шаблон» в зависимости от количества фильтров
     * @returns {BEM}
     * @private
     */
    _onFiltersChange: function() {
        var block = this.getTemplateSaving();

        this.getParent().getFiltersCount() ?
            block.enableButton('switcher') :
            block.disableButton('switcher');

        return this;
    },

    /**
     * Показываем b-confirm при успешном сохранении шаблона
     * @param {String} templateName
     * @private
     */
    _successTemplateSaveConfirm: function(templateName) {
        BEM.blocks['b-confirm'].open({
            message: iget2('b-statistic-filters-editor', 'filtr-s-sohranen', 'Фильтр "{foo}" сохранен', {
                foo: u.escapeHTML(templateName)
            }),
            type: 'alert'
        });
    },

    /**
     * Скрывает popup и ошибки, раздизейбливает кнопку, добавляет новый шаблон при успешном запросе
     * @param {String} templateName - название шаблона
     * @param {Object} filters - набор фильтров
     * @returns {BEM}
     * @private
     */
    _onSuccessSave: function(templateName, filters) {
        this.getTemplateSaving()
            .hidePopup()
            .enableButton('save')
            .hideError();

        this.getDropdownElem('templates').addTemplate(templateName, filters);

        this._successTemplateSaveConfirm(templateName);

        this.trigger('template.save', { templateName: templateName, filters: filters });

        return this;
    },

    /**
     * Устанавливает input'y новое значение
     * @param {String} templateName - название шаблона
     * @returns {BEM}
     */
    setValue: function(templateName) {
        this.getTemplateSaving().setValue(templateName);

        return this;
    },

    /**
     * Запрос на сохранение нового шаблона
     * @param {String} templateName - название шаблона
     * @returns {BEM}
     */
    saveTemplate: function(templateName) {
        var filters = this.getParent().getFiltersData({ winrate: true }),
            urlQuery = u.getUrlParams();
        this.getTemplateSaving()
            .disableButton('save');

        this.request({
            cmd: 'saveStatFilter',
            json_filters_set: JSON.stringify({
                name: templateName,
                data: u['b-statistic-filters-editor'].toServer(filters),
                cid: urlQuery.cid,
                stat_type: urlQuery.stat_type
            })
        }).then(function() {
            this._onSuccessSave(templateName, filters);
        }, function(error) {
            if (typeof error == 'string') {
                this.getTemplateSaving()
                    .showError(error);
            } else {
                this.getTemplateSaving()
                    .showError(iget2(
                    'b-statistic-filters-editor',
                    'proizoshla-neizvestnaya-oshibka-poprobuyte-127',
                    'Произошла неизвестная ошибка. Попробуйте перегрузить страницу или обратитесь к сервису позже. Извините за доставленное неудобство.'
                ))
                    .enableButton('save');
            }
        });

        return this;
    },

    _openConfirm: function(templateName) {
        BEM.blocks['b-confirm'].open({
            message: iget2(
                'b-statistic-filters-editor',
                'u-vas-uzhe-est',
                'У вас уже есть фильтр с таким названием. При сохранении нового фильтра существующий будет удален.'
            ),
            textYes: iget2('b-statistic-filters-editor', 'ok', 'ОК'),
            textNo: iget2('b-statistic-filters-editor', 'otmena', 'Отмена'),
            fromPopup: this.getPopup(),
            onYes: function() {
                this.saveTemplate(templateName);
            },
            onNo: function() {
                // afterCurrentEvent что бы выставить фокус на инпут, иначе он вернется на кнопку
                this.afterCurrentEvent(function() {
                    this.getTemplateSaving().getInput().setMod('focused', 'yes');
                });
            }
        }, this);
    }

}, {

    live: function() {
        this.__base.apply(this, arguments);

        this
            .liveInitOnParentEvent('add remove', function() {
                this._onFiltersChange();
            })
            .liveInitOnBlockEvent('save', 'b-statistics-template-saving', function(e, templateName) {
                var isResave;

                isResave = !!this.getDropdownElem('templates').findTemplate(templateName);

                isResave ?
                    this._openConfirm(templateName) :
                    this.saveTemplate(templateName);
            });

    }

});
