BEM.DOM.decl({
    block: 'b-statistic-filters-editor',
    elem: 'dropdown',
    modName: 'type',
    modVal: 'templates'
}, {

    onSetMod: {

        js: function() {
            this._currentTemplateName = (this._getTemplatelist().getSelected() || {}).name;
        }

    },

    /**
     * Загружает шаблон
     * @param {Object} data
     *  @param {String} data.title - текст выбранного шаблона
     *  @param {Object} data.params - фильтры
     * @returns {BEM}
     * @private
     */
    _onTemplateSelect: function(data) {
        if (this._notApplyTemplate) {
            this._notApplyTemplate = false;

            return this;
        }

        if (this.getParent().isTemplateChanged()) {
            BEM.blocks['b-confirm'].open({
                message: iget2('b-statistic-filters-editor', 'nastroyki-filtrov-ne-budut', 'Настройки фильтров не будут сохранены. Продолжить?'),
                textYes: iget2('b-statistic-filters-editor', 'ok', 'ОК'),
                textNo: iget2('b-statistic-filters-editor', 'otmena', 'Отмена'),
                onYes: function() {
                    this._applyTemplate(data);
                },
                onNo: function() {
                    this._notApplyTemplate = true;

                    // метод select стригерит change и повторно вызовет _onTemplateSelect
                    this._getTemplatelist().select(this._currentTemplateName);
                }
            }, this);
        } else {
            this._applyTemplate(data);
        }

        return this;
    },

    /**
     * Данные выбранного шаблона
     */
    _currentTemplateName: null,

    /**
     * Флаг, чтобы не применяется шаблон после нажатия «Отмена»
     */
    _notApplyTemplate: false,

    /**
     * Применяет выбранный шаблон
     * @param {Object} data - информация о шаблоне
     * @param {String} data.title - название
     * @param {Object} data.params - набор фильтров
     * @private
     */
    _applyTemplate: function(data) {
        var isResetTemplate = data.name == 'reset';

        this.getDropdownElem('save-template')
            .setValue(isResetTemplate ? '' : data.title);

        this.getParent().fill(data.params, isResetTemplate);

        this._currentTemplateName = data.name;
    },
    /**
     * Запрос на удаление шаблона
     * @param {Object} template - имя шаблона
     * @private
     */
    _onTemplateRemovingItem: function(template) {
        var parentParams = this.getParent().params;

        this.request({
            cmd: 'deleteStatFilter',
            filter_name: template.title,
            stat_type: template.statType || parentParams.statType,
            cid: parentParams.cid
        }).then(function() {
            this._getTemplatelist().remove(template.name);
        }, function() {
            this._getTemplatelist().onError({ type: 'remove' });
        });
    },

    /**
     * Возвращает блок со списком шаблонов
     * @returns {BEM}
     * @private
     */
    _getTemplatelist: function() {
        return this._templatelist || (this._templatelist = this.findBlockOn('b-statistics-template-list'));
    },

    /**
     * Добавляет шаблон
     * @param {String} text - текст выбранного шаблона
     * @param {Object} filters - фильтры
     * @returns {*}
     */
    addTemplate: function(text, filters) {
        this._getTemplatelist().add({
            params: filters,
            title: text,
            statType: this.getParent().params.statType,
            content: [
                u.escapeHTML(u.hellipCut(text, 35, '...')),
                u['b-statistic-filters-editor'].isCompareTemplate(filters) && {
                    block: 'b-icon',
                    mods: { 'size-13': 'compare-periods' },
                    mix: { block: 'b-statistic-filters-editor', elem: 'compare-periods-icon' }
                }
            ]
        });

        return this;
    },

    /**
     * Проверяет существование шаблона по title, возвращает его
     * @param {String} title - название
     * @returns {Object|undefined}
     */
    findTemplate: function(title) {
        return this._getTemplatelist().findTemplate(title);
    }

}, {

    live: function() {
        this.__base.apply(this, arguments);

        this
            .liveInitOnBlockEvent('select', 'b-statistics-template-list', function(e, data) {
                this._onTemplateSelect(data);
            })
            .liveInitOnBlockEvent('removing', 'b-statistics-template-list', function(e, data) {
                this._onTemplateRemovingItem(data);
            });

    }

});
