BEM.DOM.decl({
    block: 'b-statistic-filters-editor',
    elem: 'dropdown'
}, {

    /**
     * Возвращает popup
     * @returns {BEM}
     */
    getPopup: function() {
        return this.getDropdown().getPopup();
    },

    /**
     * Возвращает dropdown
     * @returns {BEM}
     */
    getDropdown: function() {
        return this._dropdown || (this._dropdown = this.findBlockOn('dropdown'));
    },

    /**
     * Возвращает экземпляр элемента dropdown
     * @returns {BEM}
     */
    getDropdownElem: function(type) {
        return this.getParent().getDropdown(type);
    },

    /**
     * Запрос на сервер
     * @param {Object} params
     * @returns {Deferred}
     */
    request: function(params) {
        var deferred = $.Deferred();

        BEM.create('i-request_type_ajax', {
            url: '/registered/main.pl',
            cache: false,
            dataType: 'json',
            type: 'POST',
            callbackCtx: this
        }).get(
            params,
            function(result) {
                if (result.error) {
                    deferred.rejectWith(this, [result.error])
                } else {
                    deferred.resolveWith(this, arguments)
                }
            },
            function(error) { deferred.rejectWith(this, arguments) });

        return deferred.promise();
    }

}, {

    live: function() {

        this.liveInitOnBlockInsideEvent('init', 'dropdown');

    }

});
