BEM.DOM.decl({
    block: 'b-statistic-filters-editor',
    elem: 'filter',
    modName: 'get-data-from',
    modVal: 'campaign'
}, {

    /**
     * Отдает настройки фильтра
     * @returns {Object|Boolean}
     * @override
     */
    getData: function() {
        var select = this.findBlockInside('select'),
            input = this.findBlockInside('input'),
            value = {},
            data = {};

        if (input && select) {
            value[select.val()] = input.val().trim()
                .replace(/\s*,\s*/g, ',') // удаляем пробелы вокруг запятых
                .replace(/,(?=,)/g, '') // оставляем только одну запятую подряд
                .replace(/^\s*/, '') // удаляем висячие пробелы в начале
                .replace(/\s*$/, '') // удаляем висячие пробелы
                .replace(/^,/, '') // удаляем висячую запятую в начале
                .replace(/,$/, '') // удаляем висячую запятую в конце
                .split(',');
        }

        data[this.params.backendName] = value;

        return data;
    }
}, {

});
