BEM.DOM.decl({
    block: 'b-statistic-filters-editor',
    elem: 'filter',
    modName: 'get-data-from',
    modVal: 'lt-gt-eq'
}, {

    /**
     * Отдает настройки фильтра
     * @returns {Object}
     * @override
     */
    getData: function() {
        var data = {},
            value = {};

        this._forEachOperation(function(instance, periodSelect, ratioSelect) {
            var period = periodSelect.val(),
                ratio = ratioSelect.val(),
                input = instance.findBlockInside('input')
                    .val()
                    .toString()
                    .replace(/ /g, '')
                    .replace(/[//,.юЮбБ<>]/gi, '.');

            input = input ? +input : '';

            if (this._compare) {
                value[period] || (value[period] = {});
                value[period][ratio] = input;
            } else {
                value[ratio] = input
            }
        });

        data[this.params.backendName] = value;

        return data;
    }

}, {

});
