BEM.DOM.decl({
    block: 'b-statistic-filters-editor',
    elem: 'filter',
    modName: 'get-data-from',
    modVal: 'not-strict-comparison'
}, {

    /**
     * Отдает настройки фильтра
     * если текстовое поле не заполнено - вернет null
     * eq - равно
     * ne - не равно
     * starts_with - строка начинается с
     * not_starts_with - строка не начинается с
     * @returns {Object|null}
     * @override
     */
    getData: function() {
        var selectValue = this.findBlockInside('select').val(),
            inputValue = $.trim(this.findBlockInside('input').val()),
            value = {},
            data = {};

        if (!inputValue) {
            return null;
        }

        if (this.findBlockInside('checkbox').isChecked()) {
            value[selectValue] = inputValue;
        } else {
            value[selectValue == 'eq' ? 'starts_with' : 'not_starts_with'] = inputValue;
        }

        data[this.params.backendName] = value;

        return data;
    }

}, {

});
