BEM.DOM.decl({
    block: 'b-statistic-filters-editor',
    elem: 'filter',
    modName: 'get-data-from',
    modVal: 'phrase'
}, {
    /**
     * Отдает настройки фильтра
     * @returns {Object}
     * @override
     */
    getData: function() {
        var selectValue = this.findBlockInside('select').val(),
            inputValue = $.trim(this.findBlockInside('input').val()),
            data = {},
            key,
            exactMatch = this.findBlockInside(this.findElem('control', 'name', 'exact-match'), 'checkbox'),
            phraseMinus = this.findBlockInside(this.findElem('control', 'name', 'phrase-minus'), 'checkbox');

        if (!inputValue) {
            return null;
        }

        switch (selectValue + (+exactMatch.isChecked()) + (+phraseMinus.isChecked())) {
            case 'eq00': key = 'contains_in_plus_part'; break;
            case 'eq11': key = 'eq'; break;
            case 'eq01': key = 'contains'; break;
            case 'ne00': key = 'not_contains_in_plus_part'; break;
            case 'ne11': key = 'ne'; break;
            case 'ne01': key = 'not_contains'; break;
        }
        data[this.params.backendName] = {};
        data[this.params.backendName][key] = inputValue;

        return data;
    }
});
