block('b-statistic-filters-editor')(

    // большое количество фильтров с одинаковым шаблоном
    elem('filter').match(function() {
        return !!~[
            'shows', 'eshows', 'clicks', 'fp-shows-avg-pos', 'avg-x', 'fp-clicks-avg-pos', 'adepth', 'aconv',
            'agoalnum', 'agoalcost', 'agoalcrr', 'agoalroi', 'agoalincome', 'ctr', 'ectr', 'sum', 'av-sum', 'bounce-ratio', 'winrate',
            'aprgoodmultigoal', 'avg-cpm', 'cpm-winrate', 'uniq-viewers', 'uniq-users-winrate', 'avg-view-freq',
            'aprgoodmultigoal-cpa', 'aprgoodmultigoal-conv-rate', 'avg-bid', 'avg-time-to-conv',
            'video-complete', 'video-true-view', 'video-avg-true-view-cost', 'video-third-quartile', 'video-midpoint', 'video-first-quartile',
            'video-complete-rate', 'video-true-view-rate', 'video-third-quartile-rate', 'video-midpoint-rate', 'video-first-quartile-rate',
            'cpcv', 'video-unmute', 'video-mute', 'auction-win-rate', 'agoals-profit',
            'imp-reach-rate', 'auction-wins', 'served-impressions', 'auction-hits', 'todo-dosmotr',
            'uniq-completed-viewers', 'ad-site-clicks', 'viewable-impressions-yandex', 'nonviewable-impressions-yandex',
            'undetermined-impressions-yandex', 'viewable-impressions-mrc', 'nonviewable-impressions-mrc',
            'undetermined-impressions-mrc', 'measured-rate-yandex', 'viewable-rate-yandex', 'measured-rate-mrc',
            'viewable-rate-mrc', 'avg-nshow', 'avg-nshow-complete',
            // Post view
            'pv-adepth', 'pv-bounce-ratio', 'pv-agoalnum', 'pv-aconv', 'pv-agoalcost', 'pv-agoalroi', 'pv-agoalincome', 'pv-agoals-profit',
            'pv-aprgoodmultigoal', 'pv-aprgoodmultigoal-cpa', 'pv-aprgoodmultigoal-conv-rate', 'pv-avg-time-to-conv', 'pv-agoalcrr'
        ].indexOf(this.elemMods.type);
    })(

        def()(function() {
            return applyNext({
                'elemMods.get-data-from': 'lt-gt-eq'
            });
        }),

        js()(function() {
            var type = this.elemMods.type,
                params = { exclusionWarnings: [] };

            if (type === 'winrate') {
                params.exclusionWarnings.push('need-winrate');
            } else if (
                [
                    'shows', 'eshows', 'ctr', 'ectr', 'fp-shows-avg-pos', 'avg-x', 'video-first-quartile',
                    'video-midpoint', 'video-midpoint-rate', 'video-complete', 'video-first-quartile-rate',
                    'video-midpoint-rate', 'video-third-quartile', 'video-third-quartile-rate', 'video-complete-rate',
                    'avg-cpm', 'cpcv', 'ad-site-clicks', 'viewable-impressions-mrc', 'nonviewable-impressions-mrc',
                    'undetermined-impressions-mrc', 'measured-rate-mrc', 'viewable-rate-mrc', 'avg-nshow',
                    'avg-nshow-complete'
                ].indexOf(type) !== -1
            ) {
                params.exclusionWarnings.push('without-click-place');
                this.ctx.extraParams.campType === 'performance' &&
                    params.exclusionWarnings.push('without-contextcond-orig');
            } else if (type === 'uniq-viewers') {
                params.exclusionWarnings.push('need-cpm-uniq', 'without-click-place');
            } else if (type === 'avg-view-freq') {
                params.exclusionWarnings.push('need-cpm-shows', 'without-click-place');
            } else if (type === 'auction-win-rate') {
                params.exclusionWarnings.push('need-cpm-auction-win-rate');
            } else if (type === 'imp-reach-rate') {
                params.exclusionWarnings.push('need-cpm-imp-reach-rate');
            } else if (type === 'auction-wins') {
                params.exclusionWarnings.push('need-cpm-auction-wins');
            } else if (type === 'auction-hits') {
                params.exclusionWarnings.push('need-cpm-auction-hits');
            } else if (type === 'served-impressions') {
                params.exclusionWarnings.push('need-cpm-served-impressions');
            } else if (type === 'uniq-completed-viewers') {
                params.exclusionWarnings.push('need-cpm-uniq-completed-viewers');
            } else if (
                [
                    'aprgoodmultigoal', 'aprgoodmultigoal-cpa', 'aprgoodmultigoal-conv-rate', 'avg-time-to-conv',
                    // Post view
                    'pv-aprgoodmultigoal', 'pv-aprgoodmultigoal-cpa', 'pv-aprgoodmultigoal-conv-rate', 'pv-avg-time-to-conv'
                ].indexOf(type) !== -1
            ) {
                params.exclusionWarnings.push('columns-without-inventory-type');
            }

            return u._.extend(params, this.ctx.js || {});
        }),

        content()(function() {
            var keys = Object.keys(this.ctx.operations),
                operations = [];

            if (keys.length) {
                keys.forEach(function(key) {
                    var value = this.ctx.operations[key];

                    if (typeof value == 'object') {
                        Object.keys(value).forEach(function(ratio) {
                            operations.push({
                                period: key,
                                ratio: ratio,
                                value: value[ratio]
                            });
                        });
                    } else {
                        operations.push({
                            period: 'a',
                            ratio: key,
                            value: value
                        });
                    }
                }, this);
            } else {
                operations.push({
                    period: 'a',
                    ratio: 'lt',
                    value: ''
                });
            }

            return operations.map(function(operation, index) {
                return {
                    elem: 'operation',
                    elemMods: { indent: index ? 'yes' : '' },
                    period: operation.period,
                    ratio: operation.ratio,
                    value: operation.value
                };
            }, this);
        })
    ),

    elem('operation').content()(function() {
        return [
            {
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: { type: 'a-b-delta' },
                selected: this.ctx.period
            },
            {
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: {
                    type: 'gt-eq-lt'
                },
                selected: this.ctx.ratio
            },
            {
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: {
                    type: 'input'
                },
                value: this.ctx.value
            },
            [
                {
                    action: 'add-operation',
                    icon: 'plus'
                },
                {
                    action: 'remove-operation',
                    icon: 'minus'
                }
            ].map(function(button) {
                return {
                    block: 'button',
                    mods: { 'only-icon': 'yes' },
                    mix: [{
                        block: 'b-statistic-filters-editor',
                        elem: 'button',
                        elemMods: { action: button.action },
                        js: true
                    }],
                    content: {
                        block: 'icon',
                        mods: { 'size-16': button.icon },
                        mix: [
                            {
                                block: 'button',
                                elem: 'icon'
                            },
                            {
                                block: 'b-statistic-filters-editor',
                                elem: 'button-icon'
                            }
                        ]
                    }
                }
            }),
            {
                block: 'b-statistic-filters-editor',
                elem: 'input-error',
                content: iget2('b-statistic-filters-editor', 'znachenie-dolzhno-byt-chislom', 'Значение должно быть числом')
            }
        ];
    })
);
