BEM.DOM.decl({
    block: 'b-statistic-filters-editor',
    elem: 'filter',
    modName: 'type',
    modVal: [
        'shows', 'eshows', 'clicks', 'fp-shows-avg-pos', 'avg-x', 'fp-clicks-avg-pos', 'adepth', 'aconv',
        'agoalnum', 'agoalcost', 'agoalcrr', 'agoalroi', 'agoalincome', 'ctr', 'ectr', 'sum', 'av-sum', 'bounce-ratio', 'winrate',
        'aprgoodmultigoal', 'avg-cpm', 'cpm-winrate', 'uniq-viewers', 'uniq-users-winrate', 'avg-view-freq',
        'aprgoodmultigoal-cpa', 'aprgoodmultigoal-conv-rate', 'avg-bid', 'avg-time-to-conv',
        'video-complete', 'video-true-view', 'video-avg-true-view-cost', 'video-third-quartile', 'video-midpoint', 'video-first-quartile',
        'video-complete-rate', 'video-true-view-rate', 'video-third-quartile-rate', 'video-midpoint-rate', 'video-first-quartile-rate',
        'cpcv', 'video-unmute', 'video-mute', 'auction-win-rate', 'agoals-profit',
        'imp-reach-rate', 'auction-wins', 'served-impressions', 'auction-hits',
        'uniq-completed-viewers', 'ad-site-clicks','viewable-impressions-yandex', 'nonviewable-impressions-yandex',
        'undetermined-impressions-yandex', 'viewable-impressions-mrc', 'nonviewable-impressions-mrc',
        'undetermined-impressions-mrc', 'measured-rate-yandex', 'viewable-rate-yandex', 'measured-rate-mrc',
        'viewable-rate-mrc', 'avg-nshow', 'avg-nshow-complete',
        // Post view
        'pv-adepth', 'pv-bounce-ratio', 'pv-agoalnum', 'pv-aconv', 'pv-agoalcost', 'pv-agoalroi', 'pv-agoalincome', 'pv-agoals-profit',
        'pv-aprgoodmultigoal', 'pv-aprgoodmultigoal-cpa', 'pv-aprgoodmultigoal-conv-rate', 'pv-avg-time-to-conv'
    ]
}, {

    onSetMod: {

        js: function() {
            this.validate();

            this._compare = this.getParent().getMod('compare');

            this._updateCompareData()
                ._updateSelects()
                ._updateActions();
        },

        'can-add': function(modName, modVal) {
            this.findBlocksInside(this.findElem('button', 'action', 'add-operation'), 'button')
                .forEach(function(button) {
                    button.toggleMod('disabled', 'yes', modVal !== 'yes');
                });
        },

        'can-remove': function(modName, modVal) {
            this.findBlocksInside(this.findElem('button', 'action', 'remove-operation'), 'button')
                .forEach(function(button) {
                    button.toggleMod('disabled', 'yes', modVal !== 'yes');
                });
        }

    },

    /**
     * Проверка на валидность
     * @returns {Boolean}
     */
    isValid: function() {
        return this._isValid;
    },

    /**
     * Статус валидации
     */
    _isValid: undefined,

    /**
     * Валидирует инпуты
     * @returns {boolean}
     */
    validate: function() {
        var isValid = true;

        this.elemInstances('operation').forEach(function(instance) {
            var input = instance.findBlockInside('input'),
                value;

            value = input.val()
                .toString()
                .replace(/ /g, '')
                .replace(/[//,.юЮбБ<>]/gi, '.');

            if ($.isNumeric(value) || !value) {
                input.delMod('error');
                instance.delMod('error');
            } else {
                input.setMod('error', 'yes');
                instance.setMod('error', 'yes');
                isValid = false;
            }
        }, this);

        return this._isValid = isValid;
    },

    _noEqOptionsMods: [
        'av-sum', 'fp-clicks-avg-pos', 'fp-shows-avg-pos', 'avg-x',
        'bounce-ratio', 'adepth', 'aconv',
        'agoalcost', 'agoalcrr', 'agoalroi',
        'aprgoodmultigoal', 'aprgoodmultigoal-cpa', 'aprgoodmultigoal-conv-rate',
        'avg-view-freq', 'avg-cpm', 'avg-bid', 'avg-time-to-conv',
        // Post view
        'pv-adepth', 'pv-bounce-ratio', 'pv-aconv', 'pv-agoalcost', 'pv-agoalroi',
        'pv-aprgoodmultigoal', 'pv-aprgoodmultigoal-cpa', 'pv-aprgoodmultigoal-conv-rate', 'pv-avg-time-to-conv'
    ],

    /**
     * Набор опций отношений для select
     */
    _ratioOptions: [
        { text: iget2('b-statistic-filters-editor', 'menshe', 'меньше'), value: 'lt' },
        { text: iget2('b-statistic-filters-editor', 'bolshe', 'больше'), value: 'gt' },
        { text: iget2('b-statistic-filters-editor', 'ravno', 'равно'), value: 'eq' }
    ],

    _noEqRationOptions: [
        { text: iget2('b-statistic-filters-editor', 'menshe', 'меньше'), value: 'lt' },
        { text: iget2('b-statistic-filters-editor', 'bolshe', 'больше'), value: 'gt' }
    ],

    /**
     * Набор опций периодов для select
     */
    _periodOptions: [
        { text: iget2('b-statistic-filters-editor', 'period-a', 'период А'), value: 'a' },
        { text: iget2('b-statistic-filters-editor', 'period-v', 'период В'), value: 'b' },
        { text: iget2('b-statistic-filters-editor', 'raznica-121', 'разница, %'), value: 'delta' },
        { text: iget2('b-statistic-filters-editor', 'raznica', 'разница'), value: 'absdelta' }
    ],

    /**
     * Суффиксы работающие только при сравнении
     */
    _warningsSuffixes: ['b', 'delta', 'absdelta'],

    /**
     * Возвращает набор опций для фильтра
     * Для некоторых фильтров нет опции равно (см https://st.yandex-team.ru/DIRECT-69520)
     * @returns {Array}
     * @private
     */
    _getRatioOptions: function() {
        return this._noEqOptionsMods.indexOf(this.getMod('type')) !== -1 ?
            this._noEqRationOptions :
            this._ratioOptions;
    },

    /**
     *
     * @param {BEM} block - экземпляр блока select
     * @param {Array} [options] - все элементы
     * @param {Object} [disabled] - неактивные элементы
     * @returns {BEM}
     * @private
     */
    _setOptions: function(block, options, disabled) {
        var selected = block.val();

        this._isAfterSetOptions = true;

        disabled || (disabled = {});

        block.setOptions(options.map(function(option) {
            var item = {
                item: 'option',
                value: option.value,
                content: option.text
            };

            // выбранные опции не дизейблим
            if (option.value === selected) {
                item.selected = true
            } else {
                disabled[option.value] && (item.disabled = true);
            }

            return item;
        }));

        return this;
    },

    /**
     * Проверяет наличие опций доступных только для сравнения
     * @returns {boolean}
     */
    needCompareWarning: function() {
        var hasCompareOperations = false;

        this._forEachOperation(function(instance, periodSelect) {
            hasCompareOperations || (hasCompareOperations = this._warningsSuffixes.indexOf(periodSelect.val()) !== -1);
        });

        return hasCompareOperations;
    },

    /**
     * Добавляет сроку(input, select)
     * @param {Event} e
     * @param {Object} data
     * @param {BEM} data.operation - экземпляр строки 'operation'
     * @returns {*}
     */
    addOperation: function(e, data) {
        var select = this.findBlockInside(this.findElem('select', 'type', 'gt-eq-lt'), 'select'),
            available = this._findAvailable(),
            operation = BEMHTML.apply({
                block: 'b-statistic-filters-editor',
                elem: 'operation',
                elemMods: { indent: 'yes' },
                ratio: available.ratio || 'lt',
                period: available.period || 'a'
            });

        if (this.elemInstances('operation').length) {
            BEM.DOM.after(data.operation.domElem, operation);
        } else {
            BEM.DOM.prepend(this.domElem, operation)
        }

        this._updateCompareData()
            ._updateSelects()
            ._updateActions();

        return this.trigger('change');
    },

    /**
     * Выставляет модификаторы влияющие на доступность действий
     * @returns {BEM}
     * @private
     */
    _updateActions: function() {
        var available = this._findAvailable();

        this._compare ?
            this.setMod('can-add', available.period ? 'yes' : 'no') :
            this.setMod('can-add', available.period === 'a' ? 'yes' : 'no');

        return this
            .setMod('can-remove', this.elemInstances('operation').length === 1 ? 'no' : 'yes');
    },

    /**
     * Удаляет сроку(input, select)
     * @param {jQuery} domElem
     * @returns {BEM}
     */
    removeOperation: function(domElem) {
        this.elemInstance(domElem).destruct();

        if (this.elemInstance('operation')) {
            this.elemInstance('operation').delMod('indent');
        }

        this.validate();
        this.trigger('change');

        return this
            ._updateCompareData()
            ._updateSelects()
            ._updateActions();
    },

    /**
     * Данные о текущем состоянии селектов и инпутов
     */
    _compareData: null,

    /**
     * Получает данные о состоянии селектов и инпутов
     * @returns {*}
     * @private
     */
    _updateCompareData: function() {
        this._compareData = {};

        return this._forEachOperation(function(instance, periodSelect, ratioSelect) {
            var period = periodSelect.val(),
                ratio = ratioSelect.val();

            this._compareData[period] || (this._compareData[period] = {});
            this._compareData[period][ratio] = instance.findBlockInside('input').val() || true;
        });
    },

    /**
     * Ищет набор параметров для следующей строки
     * @returns {Object} available
     * @returns {String} [available.ratio] - отношение
     * @returns {String} [available.period] - период
     * @returns {{ eq: true }} [available.disabled] - недоступные значения отношений
     * @private
     */
    _findAvailable: function() {
        var available = {},
            compareData = this._compareData || {};

        this._periodOptions.forEach(function(option) {
            if (available.period) { return false; }

            var key = option.value;

            if (compareData[key]) {
                if (!compareData[key].eq && !(compareData[key].lt && compareData[key].gt)) {
                    available.period = key;

                    if (compareData[key].lt || compareData[key].gt) {
                        available.disabled = { eq: true };
                        available.ratio = compareData[key].lt ? 'gt' : 'lt';
                    }
                }
            } else {
                available.period = key;
            }
        });

        return available;
    },

    /**
     * Обновляет состояние опций всех селектов
     * @returns {BEM}
     * @private
     */
    _updateSelects: function() {
        var disabledPeriods = {},
            compareData = this._compareData;

        // вычисляет недоступные периоды
        // допустимые комбинации отношений: >, <, <>, =
        u._.keys(compareData).forEach(function(key) {
            if (compareData[key].eq || (compareData[key].lt && compareData[key].gt)) {
                disabledPeriods[key] = true;
            }
        });

        this._forEachOperation(function(instance, periodSelect, ratioSelect) {
            var selectedRatio = compareData[periodSelect.val()],
                disabledRatio = {};

            if (selectedRatio.lt && selectedRatio.gt) {
                disabledRatio.eq = true;
                disabledRatio[ratioSelect.val() === 'lt' ? 'gt' : 'lt'] = true;
            }

            disabledRatio[ratioSelect.val()] = false;

            this._setOptions(periodSelect, this._periodOptions, disabledPeriods)
                ._setOptions(ratioSelect, this._getRatioOptions(), disabledRatio);
        });

        return this;
    },

    /**
     * forEach по доступным строкам
     * @param {Function} callback
     * @returns {BEM}
     * @private
     */
    _forEachOperation: function(callback) {
        this.elemInstances('operation').forEach(function(instance) {
            var period = this.findBlockOn(this.findElem(instance.domElem, 'select', 'type', 'a-b-delta'), 'select'),
                ratio = this.findBlockOn(this.findElem(instance.domElem, 'select', 'type', 'gt-eq-lt'), 'select');

            callback.call(this, instance, period, ratio);
        }, this);

        return this;
    },

    /**
     * Действия после включения сравнения
     * @private
     */
    _enableCompare: function() {},

    /**
     * Удаляет все строки кроме строк с периодом А
     * @returns {BEM}
     * @private
     */
    _disableCompare: function() {
        var hasAperiod = false;

        this._forEachOperation(function(instance, periodSelect) {
            if (periodSelect.val() !== 'a') {
                this.removeOperation(instance.domElem);
            } else {
                hasAperiod = true;
            }
        });

        hasAperiod || this.addOperation();

        return this;
    },

    /**
     * Выставляет доступное отношение для текущего периода
     * @param {jQuery} domElem
     */
    checkOperationExist: function(domElem) {
        var compareData = this._compareData,
            _this = this;

        this._forEachOperation(function(instance, periodSelect, ratioSelect) {
            var period = periodSelect.val();

            if (compareData[period] && periodSelect.domElem[0] === domElem[0]) {
                // раздизейбливаем все элементы селекта, перед тем как поменять значение
                _this._setOptions(ratioSelect, _this._getRatioOptions(), {});

                ratioSelect.val(compareData[period].gt ? 'lt' : 'gt');
            }
        });
    },

    /**
     * Проверяет значение, триггерит change
     * @private
     */
    _onInputChange: function() {
        this.validate();

        this.trigger('change', { filterType: this.getMod('type') });
    },

    /**
     * Проверяет селекты и доступные действия
     * @param {Event} e
     * @returns {BEM}
     * @private
     */
    _onSelectChange: function(e) {
        if (this._isAfterSetOptions) {
            this._isAfterSetOptions = false;

            return this;
        }

        var domElem = e.block.domElem,
            isPeriodSelect = !!this.findElem(domElem, 'select', 'type', 'a-b-delta').length,
            isRatioSelect = !!this.findElem(domElem, 'select', 'type', 'gt-eq-lt').length;

        isPeriodSelect && this.checkOperationExist(domElem);

        this._updateCompareData()
            ._updateSelects()
            ._updateActions();
    },

    /**
     * Проверяет доступные строки и доступные действия
     * @param {Event} e
     * @param {'yes'|''} modVal
     * @private
     */
    _onCompareToggle: function(e, modVal) {
        this._compare = modVal;

        this._updateCompareData()
            ._updateSelects()
            ._updateActions();

        modVal === 'yes' ?
            this._enableCompare() :
            this._disableCompare();
    },

    /**
     * Режим сравнения
     */
    _compare: null

}, {

    live: function() {
        this
            .liveInitOnParentEvent('compare', function(e, modVal) {
                this._onCompareToggle(e, modVal);
            })
            .liveInitOnBlockInsideEvent('change', 'select', function(e, data) {
                this._onSelectChange(e, data);
            })
            .liveInitOnBlockInsideEvent('change', 'input', function(e, data) {
                this._onInputChange(e, data);
            });

        return this.__base.apply(this, arguments);
    }

});

// костыль т.к. b-regions написан в .bemtree.xjst
BEM.DOM.decl({
    block: 'b-statistic-filters-editor',
    elem: 'filter',
    modName: 'type',
    modVal: ['region', 'physical-region']
}, {

    onSetMod: {

        js: function() {
            this.elemInstance(this.closestElem('row'));

            this._regionsId = (this.params.operations || {}).eq || '0';

            this._outboardControls = this.findBlockInside('b-outboard-controls')
                .on('show', this._initRegions, this)
                .on('accept', function() {
                    this._regions.provideData();
                    this._regionsId = this._regions.getGeoValue();
                    this._updateGeoText();
                }, this);

            this._updateGeoText();
        }
    },

    _initRegions: function() {
        var container,
            modelId;

        if (!this._regions) {

            // создаем модель  для дерева регионов
            modelId = 'b-statistic-filters-editor' + this.getMod('type');
            this._model = BEM.MODEL.getOrCreate({ name: 'm-geo-regions', id: modelId });

            // создаем дерево регионов
            container = this.findElem(this._outboardControls.popup.domElem, 'region-container');
            this._regions = BEM.DOM
                .append(container, BEMHTML.apply({ block: 'b-regions-adapter' }))
                .bem('b-regions-adapter');

            this._regions.prepareToShow({ modelId: modelId });

            // задаем регионы
            this._regions.setSelectedRegions(this._regionsId);

            // подтверждаем установленный набор регионов
            this._regions.provideData();
        }
    },

    /**
     * Выводит выбранные регионы пользователю
     * @private
     */
    _updateGeoText: function() {
        this.elem('geo-text')
            .text(u.getGeoNames(this._regionsId));
    }

});

BEM.DOM.decl({
    block: 'b-statistic-filters-editor',
    elem: 'filter',
    modName: 'type',
    modVal: ['phrase', 'phrase-orig', 'matched-phrase']
}, {

    /**
     * @type {BEM} чекбокс - точное соответствие
     */
    _exactMatch: null,

    /**
     * @type {BEM} чекбокс - с учетом минус-слов
     */
    _phraseMinus: null,

    /**
     * @type {Boolean} предыдущее значение чекбокса минус-фраз
     */
    _preValPhraseMinus: null,

    onSetMod: {
        js: function() {
            this._exactMatch = this.findBlockInside(this.findElem('control', 'name', 'exact-match'), 'checkbox');
            this._phraseMinus = this.findBlockInside(this.findElem('control', 'name', 'phrase-minus'), 'checkbox');
            this._exactMatch.on('change', this._onChangeExactMatch, this);

            this._exactMatch.isChecked() && this._onChangeExactMatch(null, {
                checked: this._exactMatch.isChecked()
            });
            this._preValPhraseMinus = !this._exactMatch;
        }
    },

    /**
     * Обработчик изменения состояния чекбокса "точное соответствие"
     * @param {*} e не используется
     * @param {Object} data значение чекбокса
     * @private
     */
    _onChangeExactMatch: function(e, data) {
        if (data.checked) {
            this._preValPhraseMinus = this._phraseMinus.isChecked();
            this._phraseMinus.setMod('checked', 'yes')
                .setMod('disabled', 'yes');
        } else {
            this._phraseMinus.delMod('disabled')
                .setMod('checked', this._preValPhraseMinus ? 'yes' : '')
        }
    }
});
