block('b-statistic-filters-editor').elem('filter').elemMod('type', 'ab-segment')(

    def()(function() {
        return applyNext({
            'elemMods.get-data-from': 'select'
        });
    }),

    js()(function() {
        return u._.extend({
            exclusionWarnings: [
                'auction-hits-not-supported',
                'auction-win-rate-not-supported',
                'auction-wins-not-supported'
            ]
        }, this.ctx.js);
    }),

    mode('section-value')(function() {
        return this.section.segments.map(function(segment) {
            return segment.segment_id;
        }).join(',')
    }),

    content()(function() {
        var sections = this.ctx.extraParams.sections;

        return sections.length ?
            {
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: { type: 'select' },
                options: sections.map(function(section) {
                    return {
                        text: section.section_name,
                        value: apply('section-value', { section: section })
                    };
                }),
                selected: this.ctx.operations.eq || apply('section-value', { section: sections[0] })
            } :
            iget2('b-statistic-filters-editor', 'ab-segments-not-found', 'Эксперименты не заданы.');
    })
);
