block('b-statistic-filters-editor').elem('filter').elemMod('type', 'age')(

    def()(function() {
        return applyNext({
            'elemMods.get-data-from': 'check-button'
        });
    }),

    js()(function() {
        return u._.extend({
            exclusionWarnings: [
                'without-winrate',
                'auction-hits-not-supported',
                'auction-win-rate-not-supported',
                'auction-wins-not-supported'
            ]
        }, this.ctx.js);
    }),

    content()(function() {
        var ageCategory = {
            '0-17': { text: iget2('b-statistic-filters-editor', 'mladshe-18', 'младше 18') },
            '18-24': { text: iget2('b-statistic-filters-editor', '18-24', '18-24') },
            '25-34': { text: iget2('b-statistic-filters-editor', '25-34', '25-34') },
            '35-44': { text: iget2('b-statistic-filters-editor', '35-44', '35-44') },
            '45-54': { text: iget2('b-statistic-filters-editor', '45-54', '45-54') },
            '55-': { text: iget2('b-statistic-filters-editor', 'starshe-55', 'старше 55') },
            undefined: { text: iget2('b-statistic-filters-editor', 'ne-opredelen', 'не определен') }
        };

        (this.ctx.operations.eq || ['0-17']).forEach(function(type) {
            // раньше было значение 45+,
            // в задаче https://st.yandex-team.ru/DIRECT-66902 вместо 45+ появились 2 новых значения: 45-54 и 55+
            // данное условие обеспечивает обратную совместимость
            if (type === '45-') {
                ageCategory['45-54'].checked = true;
                ageCategory['55-'].checked = true;
            } else {
                ageCategory[type].checked = true;
            }
        });

        return Object.keys(ageCategory).map(function(type) {
            return {
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: {
                    type: 'check-button',
                    name: type
                },
                checked: ageCategory[type].checked,
                text: ageCategory[type].text,
                name: type
            };
        });
    })
);
