block('b-statistic-filters-editor').elem('filter').elemMod('type', 'banner-image-type')(

    def()(function() {
        return applyNext({
            'elemMods.get-data-from': 'radio-button'
        });
    }),

    js()(function() {
        return u._.extend({
            exclusionWarnings: [
                'without-winrate',
                'without-cpm-shows',
                'without-cpm-uniq',
                'auction-hits-not-supported',
                'auction-win-rate-not-supported',
                'imp-reach-rate-not-supported',
                'served-impressions-not-supported',
                'uniq-completed-viewers-not-supported',
                'auction-wins-not-supported'
            ]
        }, this.ctx.js);
    }),

    content()(function() {
        // operations.eq == 'text_only' «текстовый»
        // operations.eq == 'text_image' «с изображением»
        // operations.eq == 'text_video' «с видео»
        // operations.eq == 'smart_creative' «с смарт-креатив»
        // operations.eq == 'smart_tgo' «смарт-объявление»
        // operations.eq == 'smart_video' «смарт-видео»
        // operations.eq == 'smart_tile' «смарт-плитка»
        // operations.eq == 'multicard' «галерея»
        var mediaType = this.ctx.extraParams.mediaType,
            availableCampTypes = this.ctx.extraParams.availableCampTypes || [],
            isMulticardEnabled = this.ctx.extraParams.isMulticardEnabled || false,
            options = {
                text_only: iget2('b-statistic-filters-editor', 'tekstovyy', 'текстовый'),
                adaptive_image: iget2('b-statistic-filters-editor', 'adaptive-image', 'графический-адаптивный'),
                text_image: iget2('b-statistic-filters-editor', 's-izobrazheniem', 'с изображением'),
                text_video: iget2('b-statistic-filters-editor', 's-video', 'с видео'),
                smart_creative: iget2('b-statistic-filters-editor', 'smart_creative', 'смарт-креатив'),
                smart_tgo: iget2('b-statistic-filters-editor', 'smart_tgo', 'смарт-объявление'),
                smart_tile: iget2('b-statistic-filters-editor', 'smart_tile', 'смарт-плитка'),
                // TODO: добавить smart_video в набор вариантов фильтра при открытии этой фичи на всех
                smart_video: iget2('b-statistic-filters-editor', 'smart_video', 'cмарт-видео'),
                multicard: iget2('b-statistic-filters-editor', 'multicard-v2', 'карусель'),
            },
            items,
            selected,
            text_items = ['text_only', 'adaptive_image', 'text_image', 'text_video'],
            smart_items = ['smart_creative', 'smart_tgo', 'smart_video', 'smart_tile'];

        if (isMulticardEnabled) {
            text_items.push('multicard');
        }

        // формируем набор вариантов фильтра
        if (mediaType) {
            if (mediaType === 'performance') {
                items = smart_items;
            } else {
                items = text_items;
            }
        } else {
            if (availableCampTypes.indexOf('performance') !== -1) {
                items = text_items.concat(smart_items);
            } else {
                items = text_items;
            }
        }

        // значение по умолчанию
        selected = this.ctx.operations.eq || items[0];

        return {
            block: 'b-statistic-filters-editor',
            elem: 'control',
            elemMods: { type: 'radio-button' },
            name: 'has-image',
            value: selected,
            options: items.map(function(value) {
                return {
                    text: options[value],
                    value: value
                };
            })
        };
    })
);
