BEM.DOM.decl({
    block: 'b-statistic-filters-editor',
    elem: 'filter',
    modName: 'type',
    modVal: 'browser'
}, {
    onSetMod: {
        js: function() {
            var operations = this.params.operations,
                dna = window.dna,
                login = u.consts('ulogin') || '',
                uaBrowserTraits = 'UA_TRAITS_BROWSER_NAME';

            if (!dna || !dna.utils || !dna.utils.getQueryExecutor) {
                throw new Error('An error has occurred in loading DNA dependencies');
            }

            var queryExecutor = dna.utils.getQueryExecutor(login);

            queryExecutor.getUaTraits([uaBrowserTraits])
                .then(function(response) {
                    this.initFilterSuggestItems(
                        response,
                        operations,
                        uaBrowserTraits,
                        this._renderBrowsersList.bind(this)
                    );
                }.bind(this))
                .catch(function() {
                    // отрисовывает фильтр с ошибкой "Браузеры не найдены"
                    this._renderBrowsersList({}, [], [])
                }.bind(this));
        }
    },

    _renderBrowsersList: function(operations, selectedProducts, browsersList) {
        var bemJson;

        if (!browsersList.length) {
            bemJson = {
                content: iget2('b-statistic-filters-editor', 'browsers-not-found', 'Произошла ошибка при запросе списка браузеров')
            };
        } else {
            bemJson = [
                {
                    block: 'b-statistic-filters-editor',
                    elem: 'control',
                    elemMods: { type: 'eq-ne' },
                    selected: operations.ne ? 'ne' : 'eq'
                },
                {
                    block: 'b-badges-multiselect',
                    mods: { type: 'multichoice' },
                    items: browsersList,
                    value: selectedProducts,
                    hint: iget2('b-statistic-filters-editor', 'choose-browsers-from-list', 'Выберите браузеры из списка')
                }]
        }

        BEM.DOM.replace(this.findElem('filter-controls'), BEMHTML.apply(bemJson));
    }
}, {
    live: function() {
        return this.__base.apply(this, arguments);
    }
});
