block('b-statistic-filters-editor').elem('filter').elemMod('type', 'campaign-strategy')(

    def()(function() {
        var campTypes = this.ctx.extraParams.campTypes,
            hasDynamicMediaCamp = campTypes.indexOf('performance') != -1,
            hasCpmMediaCamp = campTypes.some(function(mediaType) { return u.campaign.isCpm(mediaType) }),
            isInAppEventsInRmpEnabled = u.consts('isTechInAppEventsInRmpEnabled') || u.consts('isUserInAppEventsInRmpEnabled'),
            crrStrategyAllowed = u.consts('crrStrategyAllowed'),
            options = u._.compact([
                {
                    text: this.ctx.isChangeManualStrategyName ? iget2('b-statistic-filters-editor', 'ruchnoe-upravlenie-stavkami2', 'Ручное управление ставками (с оптимизацией)') : iget2('b-statistic-filters-editor', 'ruchnoe-upravlenie-stavkami', 'Ручное управление ставками (с оптимизацией в сетях)'),
                    value: 'manual_control'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'ruchnoe-upravlenie-stavkami-nezavisimoe', 'Ручное управление ставками (раздельное управление на поиске и в сетях)'),
                    value: 'manual_control_different_places'
                },
                {
                    text: iget2(
                        'b-statistic-filters-editor',
                        'optimize-clicks-avg-click',
                        'Оптимизация кликов (средняя цена клика)'
                    ),
                    value: 'autobudget_avg_click'
                },
                {
                    text: iget2(
                        'b-statistic-filters-editor',
                        'optimize-clicks-week-budget',
                        'Оптимизация кликов (недельный бюджет)'
                    ),
                    value: 'week_autobudget_avg_click'
                },
                {
                    text: iget2(
                        'b-statistic-filters-editor',
                        'optimize-clicks-week-bundle',
                        'Оптимизация кликов (пакет кликов)'
                    ),
                    value: 'autobudget_week_bundle'
                },
                {
                    text: iget2(
                        'b-statistic-filters-editor',
                        'optimize-cpa-avg-cpa',
                        'Оптимизация конверсий (средняя цена конверсии)'
                    ),
                    value: 'autobudget_avg_cpa'
                },
                {
                    text: iget2(
                        'b-statistic-filters-editor',
                        'optimize-cpa-week-budget',
                        'Оптимизация конверсий (недельный бюджет)'
                    ),
                    value: 'week_autobudget_avg_cpa'
                },
                crrStrategyAllowed && {
                    text: iget2('b-statistic-filters-editor', 'autobudget_crr', 'Целевая доля рекламных расходов'),
                    value: 'autobudget_crr'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'optimize-roi', 'Оптимизация рентабельности'),
                    value: 'autobudget_roi'
                },
                !isInAppEventsInRmpEnabled && {
                    text: iget2('b-statistic-filters-editor', 'optimize-cpi', 'Оптимизация количества установок приложения'),
                    value: 'autobudget_avg_cpi'
                },
                isInAppEventsInRmpEnabled && {
                    text: iget2('b-statistic-filters-editor', 'srednyaya-cena-ustanovki-prilozheniya', 'Средняя цена установки приложения'),
                    value: 'autobudget_avg_cpi'
                }
            ]);

        if (hasDynamicMediaCamp) {
            options.push(
                {
                    text: iget2('b-statistic-filters-editor', 'optimizaciya-kolichestva-klikov-na', 'Оптимизация количества кликов (на кампанию)'),
                    value: 'autobudget_avg_cpc_per_camp'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'optimizaciya-kolichestva-klikov-na-129', 'Оптимизация количества кликов (на фильтр)'),
                    value: 'autobudget_avg_cpc_per_filter'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'optimizaciya-kolichestva-konversiy-na', 'Оптимизация количества конверсий (на кампанию)'),
                    value: 'autobudget_avg_cpa_per_camp'
                },
                {
                    text: iget2(
                        'b-statistic-filters-editor',
                        'optimizaciya-kolichestva-konversiy-na-130',
                        'Оптимизация количества конверсий (на фильтр)'
                    ),
                    value: 'autobudget_avg_cpa_per_filter'
                }
            );
        }

        if (hasCpmMediaCamp) {
            options.push(
                {
                    text: iget2('b-statistic-filters-editor', 'snizhenie-ceny-povtornyh-pokazov-weekly', 'Снижение цены повторных показов (недельный бюджет)'),
                    value: 'autobudget_max_reach'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'snizhenie-ceny-povtornyh-pokazov-period', 'Снижение цены повторных показов (бюджет на период)'),
                    value: 'autobudget_max_reach_custom_period'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'maksimum-pokazov-po-minimalnoy-weekly', 'Максимум показов по минимальной цене (недельный бюджет)'),
                    value: 'autobudget_max_impressions'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'maksimum-pokazov-po-minimalnoy-period', 'Максимум показов по минимальной цене (бюджет на период)'),
                    value: 'autobudget_max_impressions_custom_period'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'fixing-cpm', 'Фиксированный СPM'),
                    value: 'period_fix_bid'
                }
            );
        }

        if (u.consts('isCpvStrategiesEnabled')) {
            options.push(
                {
                    text: iget2('b-statistic-filters-editor', 'optimization-prosmotrov-weekly-avg-nshow-complete', 'Оплата за просмотры (недельный бюджет)'),
                    value: 'autobudget_avg_cpv'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'optimization-prosmotrov-period-avg-nshow-complete', 'Оплата за просмотры (бюджет на период)'),
                    value: 'autobudget_avg_cpv_custom_period'
                }
            );
        }

        return applyNext({
            'elemMods.get-data-from': 'campaign-strategy',
            'ctx.options': options
        });
    }),

    content()(function() {
        var selected = this.ctx.operations.eq || [];

        // поддерживаем старый формат
        // DIRECT-63930: ТС: В сохраненном отчёте некорректно отображается стратегия
        if (typeof selected === 'string') {
            selected = [selected];
        }

        return [
            {
                block: 'dropdown',
                mix: {
                    block: 'b-statistic-filters-editor',
                    elem: 'campaign-strategy-dropdown'
                },
                mods: { theme: 'ffffff' },
                content: [
                    {
                        block: 'button',
                        mods: { pseudo: 'yes' },
                        mix: [
                            {
                                block: 'b-statistic-filters-editor',
                                elem: 'campaign-strategy-switcher'
                            },
                            {
                                block: 'dropdown',
                                elem: 'switcher'
                            }
                        ],
                        content: {
                            block: 'b-statistic-filters-editor',
                            elem: 'campaign-strategy-switcher-text',
                            content: selected.length ? iget2('b-statistic-filters-editor', 'izmenit', 'Изменить') : iget2('b-statistic-filters-editor', 'vybrat', 'Выбрать')
                        }
                    },
                    {
                        elem: 'popup',
                        mix: {
                            block: 'b-statistic-filters-editor',
                            elem: 'campaign-strategy-popup'
                        },
                        js: { directions: ['bottom-left', 'top-left'] },
                        content: {
                            block: 'b-chooser',
                            mods: { multi: 'yes' },
                            mix: {
                                block: 'b-statistic-filters-editor',
                                elem: 'campaign-strategy-chooser'
                            },
                            content: this.ctx.options.map(function(option) {
                                var elemMods = {};

                                if (selected.indexOf(option.value) !== -1) {
                                    elemMods.selected = 'yes';
                                }

                                return {
                                    elem: 'item',
                                    elemMods: elemMods,
                                    js: {
                                        text: option.text,
                                        value: option.value
                                    },
                                    content: {
                                        block: 'b-statistic-filters-editor',
                                        elem: 'campaign-strategy-chooser-item',
                                        attrs: { title: option.text },
                                        content: u.hellipCut(option.text, 60)
                                    },
                                    name: option.value
                                };
                            })
                        }
                    }
                ]
            },
            {
                block: 'b-statistic-filters-editor',
                elem: 'campaign-selected-strategies'
            }
        ];
    })
);
