BEM.DOM.decl({
    block: 'b-statistic-filters-editor',
    elem: 'filter',
    modName: 'type',
    modVal: 'campaign-strategy'
}, {

    onSetMod: {

        js: function() {
            this._getChooser().on('change', function() {
                this._updateText();
            }, this);

            this._updateText();
        }

    },

    /**
     * Обновляет текст кнопки и текст выбранных стратегий
     * @returns {BEM}
     * @private
     */
    _updateText: function() {
        var selected = this._getChooser().getSelected(),
            text = selected.map(u._.property('text')).join('</br>');

        this.elem('campaign-strategy-switcher-text').text(selected.length ? iget2('b-statistic-filters-editor', 'izmenit', 'Изменить') : iget2('b-statistic-filters-editor', 'vybrat', 'Выбрать'));
        this.elem('campaign-selected-strategies').html(text);

        return this;
    },

    /**
     * Возвращает блок b-chooser
     * @returns {BEM}
     * @private
     */
    _getChooser: function() {
        return this._chooser || (this._chooser = this.findBlockOn('campaign-strategy-chooser', 'b-chooser'));
    }

}, {});
