block('b-statistic-filters-editor').elem('filter').elemMod('type', 'campaign-type')(

    def()(function() {
        var chosen = this.ctx.operations.eq || ['text'],
            available = this.ctx.extraParams.campTypes,
            names = {
                text: iget2('b-statistic-filters-editor', 'tekstovo-graficheskie-obyavleniya', 'Текстово-графические объявления'),
                dynamic: iget2('b-statistic-filters-editor', 'dinamicheskie-obyavleniya', 'Динамические объявления'),
                mobile_content: iget2('b-statistic-filters-editor', 'reklama-mobilnyh-prilozheniy', 'Реклама мобильных приложений'),
                performance: iget2('b-statistic-filters-editor', 'smart-bannery', 'Смарт-баннеры'),
                mcbanner: iget2('b-statistic-filters-editor', 'mediyno-kontekstnyy-banner-na', 'Медийно-контекстный баннер на поиске'),
                cpm_banner: iget2('b-statistic-filters-editor', 'bannery-v-seti', 'Медийная кампания'),
                cpm_deals: iget2('b-statistic-filters-editor', 'private-deals2', 'Медийная кампания со сделками'),
                cpm_yndx_frontpage: iget2('b-statistic-filters-editor', 'cpm-yndx-frontpage', 'Медийная кампания на Главной'),
                content_promotion: iget2('b-statistic-filters-editor', 'content-promotion3', 'Продвижение контента'),
                cpm_price: iget2('b-statistic-filters-editor', 'cpm-price', 'Кампания с фиксированным СРМ')
            },
            result = {},
            isSQ = this.ctx.extraParams.statType == 'search_queries',
            isARP = this.ctx.extraParams.statType == 'ext_phrases',
            options,
            filter;

        // порядок важен DIRECT-50234
        [
            'text',
            'dynamic',
            'mobile_content',
            'performance',
            'mcbanner',
            'cpm_banner',
            'cpm_deals',
            'cpm_yndx_frontpage',
            'content_promotion',
            'cpm_price'
        ].forEach(function(type) {
            if (~available.indexOf(type)) {
                result[type] = {
                    text: names[type],
                    checked: chosen.indexOf(type) != -1
                };
            }
        });

        options = u._.filter(Object.keys(result).map(function(type) {
            // Убираем некоторые пункты из списка в зависимости от типа статистики
            if (isSQ) {
                if (!~['text', 'dynamic', 'mobile_content', 'mcbanner'].indexOf(type)) {
                    return false;
                }
            } else if (isARP) {
                if (!~['text', 'mobile_content'].indexOf(type)) {
                    return false;
                }
            } else if (type === 'cpm_deals') {
                return false;
            }

            return type;
        }));

        if (options.length == 2 && isARP) {
            return applyNext({
                // устанавливаем модификатор для извлечения данных из фильтра на клиенте
                'elemMods.get-data-from': 'radio-button',
                filterContent: {
                    block: 'b-statistic-filters-editor',
                    elem: 'control',
                    elemMods: { type: 'radio-button' },
                    name: 'campaign-type',
                    value: (u._.get(this.ctx.operations, 'eq') && u._.get(this.ctx.operations, 'eq').toString()) ||
                        'text',
                    options: options.map(function(type) {
                        return {
                            text: result[type].text,
                            value: type
                        }
                    })
                }
            });
        } else {
            return applyNext({
                // устанавливаем модификатор для извлечения данных из фильтра на клиенте
                'elemMods.get-data-from': 'check-button',
                filterContent: options.map(function(type) {
                    return {
                        block: 'b-statistic-filters-editor',
                        elem: 'control',
                        elemMods: {
                            type: 'check-button',
                            name: u.beminize(type)
                        },
                        checked: result[type].checked,
                        text: result[type].text,
                        name: type
                    };
                })
            });
        }
    }),

    content()(function() {
        return this.filterContent;
    })
);
