block('b-statistic-filters-editor').elem('filter').elemMod('type', 'campaign')(

    def()(function() {
        return applyNext({
            'elemMods.get-data-from': u.consts('rights').enableStatsMultiClientsMode ? 'campaign' : 'multiselect'
        });
    }),

    content()(function() {
        var selected = [],
            selectedId = [],
            operations = this.ctx.operations,
            campaigns = this.ctx.extraParams.campaigns;

        (operations.eq || operations.ne || [])
            .map(function(catId) {
                for (var index = 0; index < campaigns.length; index++) {
                    var camp = campaigns[index];

                    if (camp.id === catId) {
                        selectedId.push(catId);
                        selected.push(camp);
                        break;
                    }
                }
            });

        return [
            {
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: { type: 'eq-ne' },
                selected: operations.ne ? 'ne' : 'eq'
            },
            u.consts('rights').enableStatsMultiClientsMode ? {
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: {
                    type: 'textarea'
                },
                value: selectedId.join(', '),
                hint: iget2('b-statistic-filters-editor', 'campaign-cid', 'Введите номера кампаний (через запятую)')
            } : {
                block: 'b-badges-multiselect',
                mods: { type: 'campaigns' },
                items: campaigns,
                value: selected,
                suggest: {
                    mods: {
                        'without-groups': 'yes',
                        'with-select-all-favorite': 'yes',
                        'empty-state': 'enabled'
                    }
                },
                hint: iget2('b-statistic-filters-editor', 'vyberite-kampanii-iz-spiska', 'Выберите кампании из списка'),
                content: [
                    {
                        elem: 'clear'
                    },
                    {
                        elem: 'control'
                    }
                ]
            }
        ];
    })
);
