block('b-statistic-filters-editor').elem('filter').elemMod('type', 'click-place')(

    def()(function() {
        return applyNext({
            'elemMods.get-data-from': 'click-place'
        });
    }),

    js()(function() {
        return u._.extend({
            exclusionWarnings: [
                'need-click-place',
                'auction-hits-not-supported',
                'auction-win-rate-not-supported',
                'auction-wins-not-supported'
            ]
        }, this.ctx.js);
    }),

    content()(function() {
        var sitelinks = ['sitelink1', 'sitelink2', 'sitelink3', 'sitelink4', 'sitelink5', 'sitelink6', 'sitelink7', 'sitelink8'],
            selectedPlaces = {},
            isSitelinksSelect = false,
            hasDynamicMediaCamp = this.ctx.extraParams.hasDynamicMediaCamp,
            allowedDialogFeature = this.ctx.extraParams.allowedDialogFeature,
            allowedTurboForSerpWizardFeature = this.ctx.extraParams.allowedTurboForSerpWizardFeature;

        (this.ctx.operations.eq || ['title']).forEach(function(place) {
            selectedPlaces[place] = true;

            isSitelinksSelect || (isSitelinksSelect = ~place.indexOf('sitelink'));
        });

        var extraBlocks = [];
        if (allowedDialogFeature) {
            extraBlocks.push({
                block: 'b-statistic-filters-editor',
                elem: 'click-place-row',
                content: [
                    {
                        block: 'b-statistic-filters-editor',
                        elem: 'control',
                        elemMods: {
                            type: 'checkbox',
                            name: 'dialog'
                        },
                        checked: selectedPlaces['dialog'],
                        text: iget2('b-statistic-filters-editor', 'chat', 'чат')
                    }
                ]
            });
        }

        if (allowedTurboForSerpWizardFeature) {
            extraBlocks.push({
                block: 'b-statistic-filters-editor',
                elem: 'click-place-row',
                content: [
                    {
                        block: 'b-statistic-filters-editor',
                        elem: 'control',
                        elemMods: {
                            type: 'checkbox',
                            name: 'turbo_gallery'
                        },
                        checked: selectedPlaces['turbo_gallery'],
                        text: iget2('b-statistic-filters-editor', 'turbo-gallery', 'турбо-галерея')
                    }
                ]
            });
        }

        return [
            u._.compact([
                {
                    text: iget2('b-statistic-filters-editor', 'zagolovok', 'заголовок'),
                    value: 'title'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'otobrazhaemaya-ssylka', 'отображаемая ссылка'),
                    value: 'display_href'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'knopka', 'кнопка'),
                    value: 'button'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'vizitka', 'визитка'),
                    value: 'vcard'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'phone', 'телефон'),
                    value: 'phone'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'product-extensions', 'товарные дополнения'),
                    value: 'adv_gallery'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'market', 'маркет'),
                    value: 'market'
                },
                u.consts('lang') === 'ru' && u.hasClientFeature('promo_extension_enabled') && {
                    text: iget2('b-statistic-filters-editor', 'promo-extension', 'промоакция'),
                    value: 'promo_extension'
                }
            ]).map(function(place) {
                return {
                    block: 'b-statistic-filters-editor',
                    elem: 'control',
                    elemMods: {
                        type: 'checkbox',
                        name: place.value
                    },
                    checked: selectedPlaces[place.value],
                    text: place.text
                };
            }),
            {
                block: 'b-statistic-filters-editor',
                elem: 'click-place-row',
                content: [
                    {
                        block: 'b-statistic-filters-editor',
                        elem: 'control',
                        elemMods: {
                            type: 'checkbox',
                            name: 'sitelinks'
                        },
                        checked: isSitelinksSelect,
                        text: iget2('b-statistic-filters-editor', 'bystrye-ssylki-132', 'быстрые ссылки')
                    },
                    sitelinks.map(function(linkName, index) {
                        return {
                            block: 'b-statistic-filters-editor',
                            elem: 'control',
                            elemMods: { type: 'check-button' },
                            checked: selectedPlaces[linkName],
                            disabled: !isSitelinksSelect,
                            text: index + 1,
                            name: linkName
                        };
                    }),
                    hasDynamicMediaCamp && {
                        block: 'b-statistic-filters-editor',
                        elem: 'control',
                        elemMods: {
                            type: 'checkbox',
                            name: 'undefined'
                        },
                        checked: selectedPlaces['undefined'],
                        text: iget2('b-statistic-filters-editor', 'ne-opredeleno', 'не определено')
                    }
                ]
            }
        ].concat(extraBlocks);
    })
);
