BEM.DOM.decl({
    block: 'b-statistic-filters-editor',
    elem: 'filter',
    modName: 'type',
    modVal: 'click-place'
}, {

    onSetMod: {

        js: function() {
            this._getCheckbox('sitelinks').on('change', function(e, data) {
                this._toggleSitelinks(data.checked);
            }, this);
        }

    },

    /**
     * Хранилище блоков checkBox
     */
    _checkboxes: null,

    /**
     * Хранилище sitelinks
     */
    _sitelinks: null,

    /**
     * Возвращает экземпляр checkBox по name
     * @param {String} name - модификатор name элемента control
     * @returns {BEM}
     * @private
     */
    _getCheckbox: function(name) {
        this._checkboxes || (this._checkboxes = {});

        return this._checkboxes[name] ||
            (this._checkboxes[name] = this.findBlockInside(this.elem('control', 'name', name), 'checkbox'));
    },

    /**
     * Кэширует блоки check-button
     * @returns {Array}
     * @private
     */
    _getSitelinksButtons: function() {
        return this._sitelinks || (this._sitelinks = this.findBlocksInside('check-button'));
    },

    /**
     * Переключает модификатор disabled yes у check-button
     * @returns {BEM}
     * @private
     */
    _toggleSitelinks: function(condition) {
        this._getSitelinksButtons().forEach(function(checkButton) {
            checkButton
                .toggleMod('disabled', 'yes', !condition)
                .toggleMod('checked', 'yes', condition);
        });

        return this;
    }

}, {

    live: function() {
        this.liveInitOnBlockInsideEvent('init', 'checkbox');

        return this.__base.apply(this, arguments);
    }

});
