block('b-statistic-filters-editor').elem('filter').elemMod('type', 'contexttype-orig')(

    js()(function() {
        return u._.extend({
            exclusionWarnings: [
                'without-cpm-uniq',
                'without-cpm-shows',
                'auction-hits-not-supported',
                'auction-win-rate-not-supported',
                'auction-wins-not-supported'
            ]
        }, this.ctx.js);
    }),

    def()(function() {
        var contexttype = {
                phrases: { text: iget2('b-statistic-filters-editor', 'frazy', 'фразы') },
                retargeting: { text: iget2('b-statistic-filters-editor', 'usloviya-podbora-auditorii-133', 'условия подбора аудитории') }
            },
            ctx = this.ctx,
            extraParams = ctx.extraParams,
            campTypes = extraParams.campTypes,
            operations = ctx.operations.eq || ['phrases'],
            campType = u._.get(this, 'ctx.extraParams.campType'),
            isSQ = extraParams.statType == 'search_queries',
            relevanceMatchString = 'relevance-match',
            options,
            filter;

        [
            ['dynamic', iget2(
                'b-statistic-filters-editor',
                'usloviya-nacelivaniya-dinamicheskih-obyavleniy',
                'условия нацеливания динамических объявлений (ДО)'
            )],
            ['performance', iget2('b-statistic-filters-editor', 'filtry-smart-bannerov', 'фильтры смарт-баннеров')]
        ].forEach(u._.spread(function(type, text) {
            ~campTypes.indexOf(type) && (contexttype[type] = {
                text: text
            });
        }));

        u._.extend(contexttype, {
            'relevance-match': { text: iget2('b-statistic-filters-editor', 'avtotargeting', 'автотаргетинг') }
        });

        // если у нас radio-button, operations может быть объектом О_О
        if (typeof operations !== 'string') {
            operations.forEach(function(type) {
                contexttype[type].checked = true;
            });
        }

        options = u._.filter(Object.keys(contexttype).map(function(type) {

            // Убираем некоторые пункты из списка в зависимости от типа статистики
            if (isSQ) {
                //Статистика для логина, по всем кампаниям, вкладка "Поисковые запросы"
                if (!campType && !~['phrases', 'dynamic'].concat(relevanceMatchString).indexOf(type)) {
                    return false;
                //Статистика для конкретной кампании, вкладка "Поисковые запросы"
                } else if (campType) {
                    if (!~['phrases'].concat(relevanceMatchString).indexOf(type)) {
                        return false;
                    }
                }
            //МОК для РМП и ТГО
            //для РМП и ТГО в МОК есть фразы, автотаргетинг и условия ретаргетинга
            } else if (~['text', 'mobile_content'].indexOf(campType)) {
                if (!~['phrases', 'retargeting']
                    .concat(relevanceMatchString).indexOf(type)) {
                    return false;
                }
            //МОК для динамических кампапний
            } else if (campType === 'dynamic') {
                if (!~['dynamic', 'performance'].indexOf(type)) {
                    return false;
                }
                // убираем в МОЛе атвотаргетинг, если запрещен на логине
            } else if (!campType && type == 'relevance-match' && relevanceMatchString.length == 0) {
                return false;
            }

            return type;
        }));

        filter = options.map(function(type) {
            return {
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: {
                    type: 'check-button',
                    name: type
                },
                checked: contexttype[type].checked,
                text: contexttype[type].text,
                name: type
            }
        });

        return applyNext({
            // устанавливаем модификатор для извлечения данных из фильтра на клиенте
            'elemMods.get-data-from': 'check-button',
            filterContent: filter
        });
    }),

    content()(function() {
        return this.filterContent;
    })
);
