block('b-statistic-filters-editor').elem('filter').elemMod('type', 'contexttype')(

    def()(function() {
        var contexttype = {
                phrases: { text: iget2('b-statistic-filters-editor', 'frazy', 'фразы') },
                synonym: { text: iget2('b-statistic-filters-editor', 'sinonimy', 'синонимы') },
                retargeting: { text: iget2('b-statistic-filters-editor', 'usloviya-podbora-auditorii-133', 'условия подбора аудитории') },
                'auto-added-phrases': { text: iget2('b-statistic-filters-editor', 'dopolnitelnye-relevantnye-frazy-drf', 'дополнительные релевантные фразы (ДРФ)') },
                'relevance-match': { text: iget2('b-statistic-filters-editor', 'avtotargeting', 'автотаргетинг') }
            },
            ctx = this.ctx,
            extraParams = ctx.extraParams,
            campTypes = extraParams.campTypes,
            operations = ctx.operations.eq || ['phrases'],
            campType = u._.get(this, 'ctx.extraParams.campType'),
            isSQ = extraParams.statType == 'search_queries',
            isARP = extraParams.statType == 'ext_phrases',
            relevanceMatchString = 'relevance-match',
            options,
            filter;

        [
            ['dynamic', iget2(
                'b-statistic-filters-editor',
                'usloviya-nacelivaniya-dinamicheskih-obyavleniy',
                'условия нацеливания динамических объявлений (ДО)'
            )],
            ['performance', iget2('b-statistic-filters-editor', 'filtry-smart-bannerov', 'фильтры смарт-баннеров')]
        ].forEach(u._.spread(function(type, text) {
            ~campTypes.indexOf(type) && (contexttype[type] = {
                text: text
            });
        }));

        // если у нас radio-button, operations может быть объектом О_О
        if (typeof operations !== 'string') {
            operations.forEach(function(type) {
                contexttype[type].checked = true;
            });
        }

        options = u._.filter(Object.keys(contexttype).map(function(type) {

            // Убираем некоторые пункты из списка в зависимости от типа статистики
            if (isSQ) {
                //Статистика для логина, по всем кампаниям, вкладка "Поисковые запросы"
                if (!campType && !~['phrases', 'auto-added-phrases',
                    'dynamic', 'synonym'].concat(relevanceMatchString).indexOf(type)) {
                    return false;
                //Статистика для конкретной кампании, вкладка "Поисковые запросы"
                } else if (campType) {
                    //На вкладке "Поисковые запросы" тип Синонимы бывает только для РМП и ТГО
                    if (type == 'synonym') {
                        return !~['text', 'mobile_content'].indexOf(campType) ? false : type;
                    } else if (!~['phrases', 'auto-added-phrases'].concat(relevanceMatchString).indexOf(type)) {
                        return false;
                    }
                }
            } else if (isARP) {
                //Статистика для логина, по всем кампаниям, вкладка "Дополнительные фразы"
                if (!campType && !~['phrases', 'auto-added-phrases', 'dynamic'].indexOf(type)) {
                    return false;
                //Статистика для конкретной кампании, вкладка "Дополнительные фразы"
                } else if (campType && !~['phrases', 'auto-added-phrases'].indexOf(type)) {
                    return false;
                }
            //МОК для РМП и ТГО
            //для РМП и ТГО в МОК есть синонимы, автотаргетинг и условия нацеливания
            } else if (~['text', 'mobile_content'].indexOf(campType)) {
                if (!~['phrases', 'retargeting', 'auto-added-phrases', 'synonym']
                    .concat(relevanceMatchString).indexOf(type)) {
                    return false;
                }
            //МОК для динамических кампапний
            } else if (campType === 'dynamic') {
                if (!~['dynamic', 'performance'].indexOf(type)) {
                    return false;
                }
                // убираем в МОЛе атвотаргетинг, если запрещен на логине
            } else if (!campType && type == 'relevance-match' && relevanceMatchString.length == 0) {
                return false;
            }

            return type;
        }));

        if (options.length == 2 && (isSQ || isARP)) {
            return applyNext({
                // устанавливаем модификатор для извлечения данных из фильтра на клиенте
                'elemMods.get-data-from': 'radio-button',
                filterContent: {
                    block: 'b-statistic-filters-editor',
                    elem: 'control',
                    elemMods: { type: 'radio-button' },
                    name: 'contexttype',
                    value: (u._.get(this.ctx.operations, 'eq') && u._.get(this.ctx.operations, 'eq').toString()) ||
                        'phrases',
                    options: options.map(function(type) {
                        return {
                            text: contexttype[type].text,
                            value: type
                        }
                    })
                }
            });
        } else {
            return applyNext({
                // устанавливаем модификатор для извлечения данных из фильтра на клиенте
                'elemMods.get-data-from': 'check-button',
                filterContent: options.map(function(type) {
                    return {
                        block: 'b-statistic-filters-editor',
                        elem: 'control',
                        elemMods: {
                            type: 'check-button',
                            name: type
                        },
                        checked: contexttype[type].checked,
                        text: contexttype[type].text,
                        name: type
                    }
                })
            });
        }
    }),

    js()(function() {
        return u._.extend({
            exclusionWarnings: [
                'auction-hits-not-supported',
                'auction-win-rate-not-supported',
                'auction-wins-not-supported'
            ]
        }, this.ctx.js);
    }),

    content()(function() {
        return this.filterContent;
    })
);
