block('b-statistic-filters-editor').elem('filter').elemMod('type', 'criterion-type')(

    js()(function() {
        return u._.extend({
            exclusionWarnings: [
                'without-cpm-shows',
                'without-cpm-uniq',
                'auction-hits-not-supported',
                'auction-win-rate-not-supported',
                'imp-reach-rate-not-supported',
                'served-impressions-not-supported',
                'uniq-completed-viewers-not-supported',
                'auction-wins-not-supported'
            ]
        }, this.ctx.js);
    }),

    def()(function() {
        var criterionType = {
                phrases: { text: iget2('b-statistic-filters-editor', 'phrase', 'фраза') },
                retargeting: { text: iget2('b-statistic-filters-editor', 'uslovie-podbora-auditorii', 'условие подбора аудитории') },
                'webpage-filter': { text: iget2('b-statistic-filters-editor', 'filtr-po-saitu', 'фильтр по сайту') },
                'feed-filter': { text: iget2('b-statistic-filters-editor', 'filtr-po-feedu', 'фильтр по фиду') },
                'mobile-content-interest': { text: iget2('b-statistic-filters-editor', 'interes-k-mob-app', 'интерес к мобильным приложениям') },
                'relevance-match': { text: iget2('b-statistic-filters-editor', 'autotargeting', 'автотаргетинг') },
                'reach-audience': { text: iget2('b-statistic-filters-editor', 'interesi-i-socdem', 'интересы и соцдем') }
            },
            ctx = this.ctx,
            operations = ctx.operations.eq || ['phrases'],
            options,
            filter;

        // если у нас radio-button, operations может быть объектом О_О
        if (typeof operations !== 'string') {
            operations.forEach(function(type) {
                criterionType[type].checked = true;
            });
        }

        options = Object.keys(criterionType).map(function(type) {
            return type;
        });

        filter = options.map(function(type) {
            return {
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: {
                    type: 'check-button',
                    name: type
                },
                checked: criterionType[type].checked,
                text: criterionType[type].text,
                name: type
            }
        });

        return applyNext({
            // устанавливаем модификатор для извлечения данных из фильтра на клиенте
            'elemMods.get-data-from': 'check-button',
            filterContent: filter
        });
    }),

    content()(function() {
        return this.filterContent;
    })
);
