block('b-statistic-filters-editor').elem('filter').elemMod('type', 'deal-export-id')(

    def()(function() {
        return applyNext({
            'elemMods.get-data-from': 'multiselect'
        });
    }),

    js()(function() {
        return u._.extend({
            exclusionWarnings: [
                'auction-hits-not-supported',
                'auction-win-rate-not-supported',
                'auction-wins-not-supported'
            ]
        }, this.ctx.js);
    }),

    content()(function() {
        var selected = [],
            operations = this.ctx.operations,
            deals = this.ctx.extraParams.deals;

        if (!deals.length) {
            return iget2('b-statistic-filters-editor', 'sdelki-ne-naideni', 'Сделки не найдены.');
        }

        (operations.eq || operations.ne || []).map(function(catId) {
            for (var index = 0; index < deals.length; index++) {
                if (deals[index].id == catId) {
                    selected.push(deals[index]);

                    break;
                }
            }
        });

        return [
            {
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: { type: 'eq-ne' },
                selected: operations.ne ? 'ne' : 'eq'
            },
            {
                block: 'b-badges-multiselect',
                mods: { type: 'common' },
                items: deals,
                value: selected,
                suggest: {
                    mods: {
                        'without-groups': 'yes',
                        'with-select-all': 'yes',
                        'empty-state': 'enabled'
                    }
                },
                hint: iget2('b-statistic-filters-editor', 'vyberite-sdelki-iz-spiska', 'Выберите сделки из списка'),
                content: [
                    {
                        elem: 'clear'
                    },
                    {
                        elem: 'control'
                    }
                ]
            }
        ];
    })
);
