block('b-statistic-filters-editor').elem('filter').elemMod('type', 'detailed-device-type')(

    def()(function() {
        return applyNext({
            'elemMods.get-data-from': 'check-button'
        });
    }),

    js()(function() {
        return u._.extend({
            exclusionWarnings: [
                'without-winrate',
                'auction-hits-not-supported',
                'auction-win-rate-not-supported',
                'auction-wins-not-supported'
            ]
        }, this.ctx.js);
    }),

    content()(function() {
        var options = {
            android: { text: iget2('b-statistic-filters-editor', 'android', 'Android') },
            ios: { text: iget2('b-statistic-filters-editor', 'ios', 'iOS') },
            other: { text: iget2('b-statistic-filters-editor', 'ne-opredelen', 'не определен') }
        };

        (this.ctx.operations.eq || ['android']).forEach(function(type) {
            options[type].checked = true;
        });

        return Object.keys(options).map(function(type) {
            return {
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: { type: 'check-button' },
                checked: options[type].checked,
                text: options[type].text,
                name: type
            };
        })
    })
);
