block('b-statistic-filters-editor').elem('filter').elemMod('type', 'device-type')(

    def()(function() {
        return applyNext({
            'elemMods.get-data-from': 'device-type'
        });
    }),

    js()(function() {
        return u._.extend({
            exclusionWarnings: [
                'without-winrate',
                'uniq-completed-viewers-not-supported'
            ]
        }, this.ctx.js);
    }),

    content()(function() {
        var devices = {
            mobile: { text: iget2('b-statistic-filters-editor', 'mobilnye', 'мобильные') },
            tablet: { text: iget2('b-statistic-filters-editor', 'planshety', 'планшеты') },
            desktop: { text: iget2('b-statistic-filters-editor', 'desktop', 'десктоп') }
        };

        (this.ctx.operations.eq || ['mobile']).forEach(function(type) {
            devices[type].checked = true;
        });

        return Object.keys(devices).map(function(type) {
            return {
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: { type: 'check-button' },
                checked: devices[type].checked,
                text: devices[type].text,
                name: type
            };
        });
    })
);
