block('b-statistic-filters-editor').elem('filter').elemMod('type', 'dynamic')(

    def()(function() {
        return applyNext({
            'elemMods.get-data-from': 'multiselect'
        });
    }),

    js()(function() {
        return u._.extend({
            exclusionWarnings: [
                'auction-hits-not-supported',
                'auction-win-rate-not-supported',
                'auction-wins-not-supported'
            ]
        }, this.ctx.js);
    }),

    content()(function() {
        var selected = [],
            operations = this.ctx.operations,
            conditions = this.ctx.extraParams.conditions;

        if (!conditions.length) {
            return iget2('b-statistic-filters-editor', 'usloviya-nacelivaniya-ne-zadany', 'Условия нацеливания не заданы.');
        }

        (operations.eq || operations.ne || []).map(function(conditionsId) {
            for (var index = 0; index < conditions.length; index++) {
                if (conditions[index].id == conditionsId) {
                    selected.push(conditions[index]);

                    break;
                }
            }
        });

        return [
            {
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: { type: 'eq-ne' },
                selected: operations.ne ? 'ne' : 'eq'
            },
            {
                block: 'b-badges-multiselect',
                items: conditions,
                value: selected,
                hint: iget2('b-statistic-filters-editor', 'vyberite-uslovie-iz-spiska', 'Выберите условие из списка')
            }
        ];
    })
);
