block('b-statistic-filters-editor').elem('filter').elemMod('type', 'gender')(

    def()(function() {
        return applyNext({
            'elemMods.get-data-from': 'check-button'
        });
    }),

    js()(function() {
        return u._.extend({
            exclusionWarnings: [
                'without-winrate',
                'auction-hits-not-supported',
                'auction-win-rate-not-supported',
                'auction-wins-not-supported'
            ]
        }, this.ctx.js);
    }),

    content()(function() {
        var gender = {
            male: { text: iget2('b-statistic-filters-editor', 'muzhskoy', 'мужской') },
            female: { text: iget2('b-statistic-filters-editor', 'zhenskiy', 'женский') },
            undefined: { text: iget2('b-statistic-filters-editor', 'ne-opredelen', 'не определен') }
        };

        (this.ctx.operations.eq || ['male']).forEach(function(type) {
            gender[type].checked = true;
        });

        return Object.keys(gender).map(function(type) {
            return {
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: {
                    type: 'check-button',
                    name: type
                },
                checked: gender[type].checked,
                text: gender[type].text,
                name: type
            };
        });
    })
);
