block('b-statistic-filters-editor').elem('filter').elemMod('type', 'image-size')(

    def()(function() {
        return applyNext({
            'elemMods.get-data-from': 'multiselect'
        });
    }),

    js()(function() {
        return u._.extend({
            exclusionWarnings: [
                'without-winrate',
                'without-cpm-shows',
                'without-cpm-uniq',
                'auction-hits-not-supported',
                'auction-win-rate-not-supported',
                'imp-reach-rate-not-supported',
                'served-impressions-not-supported',
                'uniq-completed-viewers-not-supported',
                'auction-wins-not-supported'
            ]
        }, this.ctx.js);
    }),

    content()(function() {
        var selected = [],
            operations = this.ctx.operations,
            imageFormats = this.ctx.extraParams.formats;

        (operations.eq || operations.ne || []).map(function(catId) {
            for (var index = 0; index < imageFormats.length; index++) {
                if (imageFormats[index].id == catId) {
                    selected.push(imageFormats[index]);

                    break;
                }
            }
        });

        return [
            {
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: { type: 'eq-ne' },
                selected: operations.ne ? 'ne' : 'eq'
            },
            {
                block: 'b-badges-multiselect',
                items: imageFormats,
                value: selected,
                suggest: {
                    mods: {
                        'without-groups': 'yes',
                        'with-select-all-favorite': 'yes',
                        'empty-state': 'enabled'
                    }
                },
                hint: iget2('b-statistic-filters-editor', 'vyberite-razmery-izobrazheniy-iz', 'Выберите размеры изображений из списка'),
                content: [
                    {
                        elem: 'clear'
                    },
                    {
                        elem: 'control'
                    }
                ]
            }
        ];
    })
);
