BEM.DOM.decl({
    block: 'b-statistic-filters-editor',
    elem: 'filter',
    modName: 'type',
    modVal: 'internal-product-name'
}, {

    onSetMod: {
        js: function() {
            var operations = this.params.operations,
                selected = [];

            BEM.blocks['i-web-api-request'].internalAds.getProducts()
                .then(function(response) {
                    var productsList = response.result.map(function(item) {
                        return {
                            id: item.productId,
                            title: item.productName
                        }
                    });

                    (operations.eq || operations.ne || []).map(function(catId) {
                        for (var index = 0; index < productsList.length; index++) {
                            if (productsList[index].id == catId) {
                                selected.push(productsList[index]);
                                break;
                            }
                        }
                    });

                    this._setProductsList(operations, selected, productsList);
                }.bind(this))
                .catch(function() {
                    // отрисовывает фильтр с ошибкой "Продукты не найдены"
                    this._setProductsList({}, [], [])
                }.bind(this));
        }
    },

    _setProductsList: function(operations, selectedProducts, productsList) {
        var bemJson;

        if (!productsList.length) {
            bemJson = {
                content: iget2('b-statistic-filters-editor', 'products-not-found', 'Продукты не найдены')
            };
        } else {
            bemJson = [
                {
                    block: 'b-statistic-filters-editor',
                    elem: 'control',
                    elemMods: { type: 'eq-ne' },
                    selected: operations.ne ? 'ne' : 'eq'
                },
                {
                    block: 'b-badges-multiselect',
                    mods: { type: 'multichoice' },
                    items: productsList,
                    value: selectedProducts,
                    hint: iget2('b-statistic-filters-editor', 'choose-product-names-from-list', 'Выберите продукты из списка')
                }]
        }

        BEM.DOM.replace(this.findElem('filter-controls'), BEMHTML.apply(bemJson));
    }
}, {
    live: function() {
        return this.__base.apply(this, arguments);
    }
});
