block('b-statistic-filters-editor').elem('filter').elemMod('type', 'inventory-type')(

    def()(function() {
        return applyNext({
            'elemMods.get-data-from': 'inventory-type'
        });
    }),

    js()(function() {
        return u._.extend({
            exclusionWarnings: [
                'without-inventory-type',
                'auction-hits-not-supported',
                'auction-win-rate-not-supported',
                'auction-wins-not-supported'
            ]
        }, this.ctx.js);
    }),

    content()(function() {
        var inventoryTypes = {
            inpage: { text: iget2('b-statistic-filters-editor', 'inpage', 'Текстовый контент') },
            instream_web: { text: iget2('b-statistic-filters-editor', 'instream-web', 'Потоковое видео') },
            interstitial: { text: iget2('b-statistic-filters-editor', 'interstitial', 'Приложения') }
        };

        if (u.consts('isFeatureVideoInventoryModifiersEnabled')) {
            inventoryTypes.inbanner = {
                text: iget2('b-statistic-filters-editor', 'inbanner', 'Видео в баннере')
            };
            inventoryTypes.rewarded = {
                text: iget2('b-statistic-filters-editor', 'rewarded', 'Видео за вознаграждение')
            };
        }

        (this.ctx.operations.eq || []).forEach(function(type) {
            inventoryTypes[type].checked = true;
        });

        return Object.keys(inventoryTypes).map(function(type) {
            return {
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: { type: 'check-button' },
                checked: inventoryTypes[type].checked,
                text: inventoryTypes[type].text,
                name: type
            };
        });
    })
);
