block('b-statistic-filters-editor').elem('filter').elemMod('type', 'match-type')(

    def()(function() {
        return applyNext({
            'elemMods.get-data-from': 'check-button'
        });
    }),

    js()(function() {
        return u._.extend({
            exclusionWarnings: [
                'without-cpm-shows',
                'without-cpm-uniq',
                'auction-hits-not-supported',
                'auction-win-rate-not-supported',
                'imp-reach-rate-not-supported',
                'served-impressions-not-supported',
                'uniq-completed-viewers-not-supported',
                'auction-wins-not-supported'
            ]
        }, this.ctx.js);
    }),

    content()(function() {
        var options = {
            none: { text: iget2('b-statistic-filters-editor', 'bez-tipa-sootvetstviya', 'без типа соответствия') },
            syn: { text: iget2('b-statistic-filters-editor', 'semantic', 'семантическое') },
            rkw: { text: iget2('b-statistic-filters-editor', 'dopolnitelnaya-relevantnaya-fraza-drf', 'дополнительная релевантная фраза (ДРФ)') },
            kwd: { text: iget2('b-statistic-filters-editor', 'word_by_word', 'пословное') }
        };

        (this.ctx.operations.eq || ['none']).forEach(function(type) {
            options[type].checked = true;
        });

        return Object.keys(options).map(function(type) {
            return {
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: { type: 'check-button' },
                checked: options[type].checked,
                text: options[type].text,
                name: type
            };
        });
    })
);
