BEM.DOM.decl({
    block: 'b-statistic-filters-editor',
    elem: 'filter',
    modName: 'type',
    modVal: 'operating-system'
}, {
    onSetMod: {
        js: function() {
            var operations = this.params.operations,
                dna = window.dna,
                login = u.consts('ulogin') || '',
                uaOsNameTraits = 'UA_TRAITS_OS_FAMILY';

            if (!dna || !dna.utils || !dna.utils.getQueryExecutor) {
                throw new Error('An error has occurred in loading DNA dependencies');
            }

            var queryExecutor = dna.utils.getQueryExecutor(login);

            queryExecutor.getUaTraits([uaOsNameTraits])
                .then(function(response) {
                    this.initFilterSuggestItems(
                        response,
                        operations,
                        uaOsNameTraits,
                        this._renderOsNamesList.bind(this)
                    );
                }.bind(this))
                .catch(function() {
                    // отрисовывает фильтр с ошибкой "Операционные системы не найдены"
                    this._renderOsNamesList({}, [], [])
                }.bind(this));
        }
    },

    _renderOsNamesList: function(operations, selectedProducts, osFamiliesList) {
        var bemJson;

        if (!osFamiliesList.length) {
            bemJson = {
                content: iget2('b-statistic-filters-editor', 'os-families-not-found', 'Произошла ошибка при получении списка операционных систем')
            };
        } else {
            bemJson = [
                {
                    block: 'b-statistic-filters-editor',
                    elem: 'control',
                    elemMods: { type: 'eq-ne' },
                    selected: operations.ne ? 'ne' : 'eq'
                },
                {
                    block: 'b-badges-multiselect',
                    mods: { type: 'multichoice' },
                    items: osFamiliesList,
                    value: selectedProducts,
                    hint: iget2('b-statistic-filters-editor', 'choose-os-families-from-list', 'Выберите операционные системы из списка')
                }]
        }

        BEM.DOM.replace(this.findElem('filter-controls'), BEMHTML.apply(bemJson));
    }
}, {
    live: function() {
        return this.__base.apply(this, arguments);
    }
});
