block('b-statistic-filters-editor').elem('filter').elemMod('type', 'performance')(

    def()(function() {
        return applyNext({
            'elemMods.get-data-from': 'multiselect'
        });
    }),

    js()(function() {
        return u._.extend({
            exclusionWarnings: [
                'shows-not-supported',
                'contextcond-orig',
                'auction-hits-not-supported',
                'auction-win-rate-not-supported',
                'auction-wins-not-supported'
            ]
        }, this.ctx.js);
    }),

    content()(function() {
        var selected = [],
            operations = this.ctx.operations,
            filters = this.ctx.extraParams.filters;

        if (!filters.length) {
            return iget2('b-statistic-filters-editor', 'filtry-ne-zadany', 'Фильтры не заданы.');
        }

        (operations.eq || operations.ne || []).map(function(filterId) {
            for (var index = 0; index < filters.length; index++) {
                if (filters[index].id == filterId) {
                    selected.push(filters[index]);

                    break;
                }
            }
        });

        return [
            {
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: { type: 'eq-ne' },
                selected: operations.ne ? 'ne' : 'eq'
            },
            {
                block: 'b-badges-multiselect',
                items: filters,
                value: selected,
                hint: iget2('b-statistic-filters-editor', 'vyberite-filtr-iz-spiska', 'Выберите фильтр из списка')
            }
        ];
    })
);
