block('b-statistic-filters-editor').elem('filter').elemMod('type', 'phrase')(

    def()(function() {
        return applyNext({
            'elemMods.get-data-from': 'phrase'
        });
    }),

    js()(function() {
        return u._.extend({
            exclusionWarnings: [
                'auction-hits-not-supported',
                'auction-win-rate-not-supported',
                'auction-wins-not-supported'
            ]
        }, this.ctx.js);
    }),

    content()(function() {
        var operations = this.ctx.operations,
            value = operations.eq || operations.contains || operations.ne ||
                operations.not_contains || operations.contains_in_plus_part || operations.not_contains_in_plus_part;

        return [
            {
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: { type: 'eq-ne' },
                selected: 'ne' in operations || 'not_contains_in_plus_part' in operations ||
                    'not_contains' in operations ? 'ne' : 'eq'
            },
            {
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: {
                    type: 'checkbox',
                    name: 'exact-match'
                },
                checked: 'ne' in operations || 'eq' in operations,
                text: iget2('b-statistic-filters-editor', 'tochnoe-sootvetstvie', 'точное соответствие')
            },
            {
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: {
                    type: 'checkbox',
                    name: 'phrase-minus'
                },
                checked: ['eq', 'contains', 'ne', 'not_contains'].some(function(key) {
                    return key in operations;
                }),
                text: iget2('b-statistic-filters-editor', 's-uchetom-minus-slov', 'с учетом минус-слов')
            },
            {
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: { type: 'textarea' },
                value: value,
                hint: iget2('b-statistic-filters-editor', 'razdelyayte-frazy-perevodom-stroki', 'Разделяйте фразы переводом строки')
            }
        ];
    })
);
