BEM.DOM.decl({
    block: 'b-statistic-filters-editor',
    elem: 'filter',
    modName: 'type',
    modVal: 'place-id'
}, {

    onSetMod: {
        js: function() {
            var operations = this.params.operations,
                selected = [];

            BEM.blocks['i-web-api-request'].internalAds.getPlaces()
                .then(function(response) {
                    var placesList = response.result.map(function(item) {
                        return {
                            id: item.id,
                            title: item.id + ' - ' + item.fullDescription
                        }
                    });

                    (operations.eq || operations.ne || []).map(function(catId) {
                        for (var index = 0; index < placesList.length; index++) {
                            if (placesList[index].id == catId) {
                                selected.push(placesList[index]);
                                break;
                            }
                        }
                    });

                    this._setPlacesList(operations, selected, placesList);
                }.bind(this))
                .catch(function() {
                    // отрисовывает фильтр с ошибкой "Плейсы не найдены"
                    this._setPlacesList({}, [], [])
                }.bind(this));
        }
    },

    _setPlacesList: function(operations, selectedPlaces, placesList) {
        var bemJson;

        if (!placesList.length) {
            bemJson = {
                content: iget2('b-statistic-filters-editor', 'places-not-found', 'Плейсы не найдены')
            };
        } else {
            bemJson = [
                {
                    block: 'b-statistic-filters-editor',
                    elem: 'control',
                    elemMods: { type: 'eq-ne' },
                    selected: operations.ne ? 'ne' : 'eq'
                },
                {
                    block: 'b-badges-multiselect',
                    mods: { type: 'multichoice' },
                    items: placesList,
                    value: selectedPlaces,
                    hint: iget2('b-statistic-filters-editor', 'choose-places-from-list', 'Выберите плейсы из списка')
                }]
        }

        BEM.DOM.replace(this.findElem('filter-controls'), BEMHTML.apply(bemJson));
    }
}, {
    live: function() {
        return this.__base.apply(this, arguments);
    }
});
