block('b-statistic-filters-editor').elem('filter').elemMod('type', 'position')(

    def()(function() {
        return applyNext({
            'elemMods.get-data-from': 'check-button'
        });
    }),

    js()(function() {
        return u._.extend({
            exclusionWarnings: [
                'auction-hits-not-supported',
                'auction-win-rate-not-supported',
                'auction-wins-not-supported'
            ]
        }, this.ctx.js);
    }),

    content()(function() {
        var eq = this.ctx.operations.eq,
            options = {
                prime: { text: iget2('b-statistic-filters-editor', 'specrazmeshchenie', 'спецразмещение') },
                'non-prime': { text: iget2('b-statistic-filters-editor', 'prochee', 'прочее') },
                alone: { text: iget2('b-statistic-filters-editor', 'exclusive-position', 'эксклюзивное размещение') },
                suggest: { text: iget2('b-statistic-filters-editor', 'suggest-position', 'реклама в саджесте') },
                'adv-gallery': { text: iget2('b-statistic-filters-editor', 'adv-gallery', 'товарная галерея') }
            };

        if (typeof eq === 'string') {
            eq = [eq];
        }

        if (!eq) {
            eq = ['prime'];
        }

        eq.forEach(function(type) {
            options[type].checked = true;
        });

        return Object.keys(options).map(function(type) {
            return {
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: { type: 'check-button' },
                checked: options[type].checked,
                text: options[type].text,
                name: type
            };
        });
    })
);
