block('b-statistic-filters-editor').elem('filter').elemMod('type', 'region')(

    def()(function() {
        return applyNext({
            'elemMods.get-data-from': 'region'
        });
    }),

    js()(function() {
        return u._.extend({
            operations: this.ctx.operations
        }, this.ctx.js);
    }),

    content()(function() {
        var type = 'region';

        return [
            {
                block: 'b-outboard-controls',
                js: {
                    id: 'regions-controls' + type
                },
                mix: [{
                    block: 'b-statistic-filters-editor',
                    elem: 'regions-switcher',
                    elemMods: {
                        type: type
                    }
                }],
                content: {
                    elem: 'switcher',
                    js: {
                        innerBlockParams: {
                            modelId: 'b-statistic-filters-editor' + type
                        }
                    },
                    switcher: {
                        block: 'button',
                        mods: {
                            pseudo: 'yes'
                        },
                        content: iget2('b-statistic-filters-editor', 'utochnit', 'уточнить')
                    }
                }
            },
            {
                block: 'b-outboard-controls',
                js: {
                    id: 'regions-controls' + type
                },
                content: {
                    elem: 'popup',
                    mix: [{
                        block: 'b-statistic-filters-editor',
                        elem: 'regions-popup'
                    }],
                    directions: [
                        {
                            to: 'top',
                            axis: 'left',
                            tail: { axis: 'right' }
                        },
                        'bottom',
                        'right',
                        'left'
                    ],
                    header: iget2('b-statistic-filters-editor', 'vybor-regionov', 'Выбор регионов'),
                    innerBlock: {
                        // контейнер для дерева регионов (рендерится на клиенте)
                        block: 'b-statistic-filters-editor',
                        elem: 'region-container'
                    },
                    acceptButtonText: iget2('b-statistic-filters-editor', 'ok', 'ОК')
                }
            },
            { elem: 'geo-text' }
        ];
    })
);
