block('b-statistic-filters-editor').elem('filter').elemMod('type', 'retargeting')(

    def()(function() {
        return applyNext({
            'elemMods.get-data-from': 'multiselect'
        });
    }),

    js()(function() {
        return u._.extend({
            exclusionWarnings: [
                'auction-hits-not-supported',
                'auction-win-rate-not-supported',
                'auction-wins-not-supported'
            ]
        }, this.ctx.js);
    }),

    content()(function() {
        var selected = [],
            operations = this.ctx.operations,
            retargetings = this.ctx.extraParams.retargetings;

        if (!retargetings.length) {
            return iget2('b-statistic-filters-editor', 'usloviya-podbora-auditorii-ne', 'Условия подбора аудитории не заданы.');
        }

        (operations.eq || operations.ne || []).map(function(retargetingId) {
            for (var index = 0; index < retargetings.length; index++) {
                if (retargetings[index].id == retargetingId) {
                    selected.push(retargetings[index]);

                    break;
                }
            }
        });

        return [
            {
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: { type: 'eq-ne' },
                selected: operations.ne ? 'ne' : 'eq'
            },
            {
                block: 'b-badges-multiselect',
                items: retargetings,
                value: selected,
                hint: iget2('b-statistic-filters-editor', 'vyberite-uslovie-iz-spiska', 'Выберите условие из списка')
            }
        ];
    })
);
