block('b-statistic-filters-editor').elem('filter').elemMod('type', 'rmp-interest')(

    def()(function() {
        return applyNext({
            'elemMods.get-data-from': 'multiselect'
        });
    }),

    js()(function() {
        return u._.extend({
            exclusionWarnings: [
                'auction-hits-not-supported',
                'auction-win-rate-not-supported',
                'auction-wins-not-supported'
            ]
        }, this.ctx.js);
    }),

    content()(function() {
        var selected = [],
            operations = this.ctx.operations,
            interests = this.ctx.extraParams.interests;

        if (!interests.length) {
            return iget2('b-statistic-filters-editor', 'interesy-ne-zadany', 'Интересы не заданы.');
        }

        (operations.eq || operations.ne || []).map(function(interestId) {
            for (var index = 0; index < interests.length; index++) {
                if (interests[index].id == interestId) {
                    selected.push(interests[index]);

                    break;
                }
            }
        });

        return [
            {
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: { type: 'eq-ne' },
                selected: operations.ne ? 'ne' : 'eq'
            },
            {
                block: 'b-badges-multiselect',
                items: interests,
                value: selected,
                hint: iget2('b-statistic-filters-editor', 'vyberite-interesy-iz-spiska', 'Выберите интересы из списка')
            }
        ];
    })
);
