block('b-statistic-filters-editor').elem('filter').elemMod('type', 'tags')(

    def()(function() {
        return applyNext({
            'elemMods.get-data-from': 'tags'
        });
    }),

    js()(function() {
        return u._.extend({
            exclusionWarnings: [
                'without-winrate',
                'without-cpm-shows',
                'without-cpm-uniq',
                'auction-hits-not-supported',
                'auction-win-rate-not-supported',
                'imp-reach-rate-not-supported',
                'served-impressions-not-supported',
                'uniq-completed-viewers-not-supported',
                'auction-wins-not-supported'
            ]
        }, this.ctx.js);
    }),

    content()(function() {
        var selected = [],
            operations = this.ctx.operations,
            tags = this.ctx.extraParams.tags;

        if (!tags.length) {
            return iget2('b-statistic-filters-editor', 'metki-ne-zadany', 'Метки не заданы.');
        }

        (operations.eq || operations.ne || []).map(function(tag) {
            for (var index = 0; index < tags.length; index++) {
                if (tags[index].title == tag) {
                    selected.push(tags[index]);

                    break;
                }
            }
        });

        return [
            {
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: { type: 'eq-ne' },
                selected: operations.ne ? 'ne' : 'eq'
            },
            {
                block: 'b-badges-multiselect',
                items: tags,
                value: selected,
                hint: iget2('b-statistic-filters-editor', 'vyberite-metki-iz-spiska', 'Выберите метки из списка')
            }
        ];
    })
);
