block('b-statistic-filters-editor').elem('filter').elemMod('type', 'targeting-category')(
    def()(function() {
        return applyNext({
            'elemMods.get-data-from': 'check-button'
        });
    }),

    js()(function() {
        return u._.extend({
            exclusionWarnings: [
                'auction-hits-not-supported',
                'auction-win-rate-not-supported',
                'auction-wins-not-supported'
            ]
        }, this.ctx.js);
    }),

    content()(function() {
        var values = {
            exact: { text: iget2('b-statistic-filters-editor', 'celevye-zaprosy', 'Целевые запросы') },
            alternative: { text: iget2('b-statistic-filters-editor', 'alternativnye-zaprosy', 'Альтернативные запросы') },
            competitor: { text: iget2('b-statistic-filters-editor', 'zaprosy-s-upominaniem-konkurentov', 'Запросы с упоминанием конкурентов') },
            broader: { text: iget2('b-statistic-filters-editor', 'shirokie-zaprosy', 'Широкие запросы') },
            accessory: { text: iget2('b-statistic-filters-editor', 'soputstvuyushchie-zaprosy', 'Сопутствующие запросы') },
            undefined: { text: iget2('b-statistic-filters-editor', 'ne-opredelena', 'Не определена') }
        };

        (this.ctx.operations.eq || ['exact']).forEach(function(type) {
            values[type].checked = true;
        });

        return Object.keys(values).map(function(type) {
            return {
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: { type: 'check-button' },
                checked: values[type].checked,
                text: values[type].text,
                name: type
            };
        });
    })
);
