BEM.DOM.decl({
    block: 'b-statistic-filters-editor',
    elem: 'filter',
    modName: 'type',
    modVal: 'template-id'
}, {

    onSetMod: {
        js: function() {
            var operations = this.params.operations,
                selected = [],
                dna = window.dna,
                login = u.consts('ulogin') || ''

            if (!dna || !dna.utils || !dna.utils.getQueryExecutor) {
                throw new Error('An error has occurred in loading DNA dependencies');
            }

            var queryExecutor = dna.utils.getQueryExecutor(login);

            queryExecutor.getInternalPlaceTemplates()
                .then(function(response) {
                    // response: Array<{ placeId: string; templateId: string }>;
                    var templatesList,
                        templateAssociatedWithPlaces = response.reduce(function(acc, item) {
                            if (acc[item.templateId]) {
                                acc[item.templateId].push(item.placeId)
                            } else {
                                acc[item.templateId] = [item.placeId]
                            }
                            return acc;
                        }, {})

                    // templateList: Array<{ id: string; title: string }>;
                    templatesList = Object.keys(templateAssociatedWithPlaces)
                        .map(function(templateId) {
                            return {
                                id: templateId,
                                title: templateId + ' (places: ' +
                                    templateAssociatedWithPlaces[templateId].join(', ') + ')'
                            };
                        });

                    (operations.eq || operations.ne || []).map(function(catId) {
                        for (var index = 0; index < templatesList.length; index++) {
                            if (templatesList[index].id == catId) {
                                selected.push(templatesList[index]);
                                break;
                            }
                        }
                    });

                    this._setTemplatesList(operations, selected, templatesList);
                }.bind(this))
                .catch(function() {
                    // отрисовывает фильтр с ошибкой "Шаблоны не найдены"
                    this._setTemplatesList({}, [], [])
                }.bind(this));
        }
    },

    _setTemplatesList: function(operations, selectedTemplatesPlaces, templatesList) {
        var bemJson;

        if (!templatesList.length) {
            bemJson = {
                content: iget2('b-statistic-filters-editor', 'templates-not-found', 'Шаблоны не найдены')
            }
        } else {
            bemJson = [
                {
                    block: 'b-statistic-filters-editor',
                    elem: 'control',
                    elemMods: { type: 'eq-ne' },
                    selected: operations.ne ? 'ne' : 'eq'
                },
                {
                    block: 'b-badges-multiselect',
                    mods: { type: 'multichoice' },
                    items: templatesList,
                    value: selectedTemplatesPlaces,
                    hint: iget2('b-statistic-filters-editor', 'choose-templates-from-list', 'Выберите шаблоны из списка')
                }]
        }

        BEM.DOM.replace(this.findElem('filter-controls'), BEMHTML.apply(bemJson));
    }
}, {
    live: function() {
        return this.__base.apply(this, arguments);
    }
});
