BEM.DOM.decl({
    block: 'b-statistic-filters-editor',
    elem: 'filter'
}, {

    /**
     * Отдает настройки фильтра
     * @returns {Object|Boolean}
     * @override
     */
    getData: function() {
        return {/* Переопределяется в модификаторах элемента */};
    },

    /**
     * Принимает данные о столбцах и срезах.
     * На основе этих данных проверяет необходимость показывать предупреждения.
     * При необходимости показывает предупреждения.
     * @param {Array} columns - массив выбранных столбцов
     * @param {Array} slices - массив выбранных срезов
     * @returns {Array}
     * */
    exclusionWarnings: function(columns, slices) {
        var _this = this,
            exclusions = this.params.exclusionWarnings || [];

        u._.isString(exclusions) && (exclusions = [exclusions]);

        return this._updateExclusionWarnings(exclusions.reduce(function(prev, name) {
            return prev.concat(_this._exclusionWarningsMatchers[name](columns, slices));
        }, []));
    },

    /**
     * Включенные предупреждения.
     * Используется для проверки наличия предупреждений.
     * @private
     * */
    _exclusionWarnings: null,

    /**
     * Методы проверяющие условия и возвращающие текст предупреждения
     * @private
     * */
    _exclusionWarningsMatchers: {
        adgroup: function(columns, slices) {
            if (!!~columns.indexOf('winrate') && !~slices.indexOf('adgroup')) {
                return iget2(
                    'b-statistic-filters-editor',
                    'uslovie-filtracii-ignoriruetsya-vyberite',
                    'Условие фильтрации игнорируется. Выберите срез «Группы» или отключите столбец «Процент полученных показов»'
                );
            }
            return [];
        },
        'contextcond-orig': function(columns, slices) {
            if (!!~columns.indexOf('winrate') && !~slices.indexOf('contextcond_orig')) {
                return iget2(
                    'b-statistic-filters-editor',
                    'uslovie-filtracii-ignoriruetsya-vyberite-122',
                    'Условие фильтрации игнорируется. Выберите срез «Условия показа» или отключите столбец «Процент полученных показов»'
                );
            }
            return [];
        },
        'without-contextcond-orig': function(columns, slices) {
            if (~slices.indexOf('contextcond_orig')) {
                return iget2(
                    'b-statistic-filters-editor',
                    'uslovie-filtracii-ignoriruetsya-esli',
                    'Условие фильтрации игнорируется, если выбран срез «Условие показа»'
                );
            }
            return [];
        },
        contextcond: function(columns, slices) {
            if (!!~columns.indexOf('winrate') && !~slices.indexOf('contextcond')) {
                return iget2(
                    'b-statistic-filters-editor',
                    'uslovie-filtracii-ignoriruetsya-vyberite-122',
                    'Условие фильтрации игнорируется. Выберите срез «Условия показа» или отключите столбец «Процент полученных показов»'
                );
            }
            return [];
        },
        'without-contextcond': function(columns, slices) {
            if (~slices.indexOf('contextcond')) {
                return iget2(
                    'b-statistic-filters-editor',
                    'uslovie-filtracii-ignoriruetsya-esli',
                    'Условие фильтрации игнорируется, если выбран срез «Условие показа»'
                );
            }
            return [];
        },
        'need-click-place': function(columns, slices) {
            if (!~slices.indexOf('click_place')) {
                return iget2(
                    'b-statistic-filters-editor',
                    'uslovie-filtracii-ignoriruetsya-esli-123',
                    'Условие фильтрации игнорируется, если не выбран срез «Место клика»'
                );
            }
            return [];
        },
        'need-winrate': function(columns) {
            if (!~columns.indexOf('winrate')) {
                return iget2(
                    'b-statistic-filters-editor',
                    'uslovie-filtracii-ignoriruetsya-esli-124',
                    'Условие фильтрации игнорируется, если не выбран столбец «Процент полученных показов»'
                );
            }
            return [];
        },
        'without-click-place': function(columns, slices) {
            if (~slices.indexOf('click_place')) {
                return iget2(
                    'b-statistic-filters-editor',
                    'uslovie-filtracii-ignoriruetsya-esli-125',
                    'Условие фильтрации игнорируется, если выбран срез «Место клика»'
                );
            }
            return [];
        },
        'without-winrate': function(columns) {
            if (~columns.indexOf('winrate')) {
                return iget2(
                    'b-statistic-filters-editor',
                    'uslovie-filtracii-ignoriruetsya-esli-126',
                    'Условие фильтрации игнорируется, если выбран столбец «Процент полученных показов»'
                );
            }
            return [];
        },
        'without-cpm-uniq': function(columns) {
            if (~columns.indexOf('uniq_viewers')) {
                return iget2(
                    'b-statistic-filters-editor',
                    'uslovie-filtracii-ignoriruetsya-esli-vibran-stolbec-ohvat',
                    'Условие фильтрации игнорируется, если выбран столбец «Охват»'
                );
            }
            return [];
        },
        'without-cpm-shows': function(columns) {
            if (~columns.indexOf('avg_view_freq')) {
                return iget2(
                    'b-statistic-filters-editor',
                    'uslovie-filtracii-ignoriruetsya-esli-vibran-stolbec-sr-chastota-pokazov',
                    'Условие фильтрации игнорируется, если выбран столбец «Ср. частота показов»'
                );
            }
            return [];
        },
        'need-cpm-uniq': function(columns, slices) {
            if (this.hasNonCpmSlices(slices) && !~columns.indexOf('uniq_viewers')) {
                return iget2(
                    'b-statistic-filters-editor',
                    'uslovie-filtracii-ignoriruetsya-esli-nevibran-stolbec-ohvat',
                    'Условие фильтрации игнорируется, если не выбран столбец «Охват»'
                );
            }
            return [];
        },
        'need-cpm-shows': function(columns, slices) {
            if (this.hasNonCpmSlices(slices) && !~columns.indexOf('avg_view_freq')) {
                return iget2(
                    'b-statistic-filters-editor',
                    'uslovie-filtracii-ignoriruetsya-esli-nevibran-stolbec-sr-chastota-pokazov',
                    'Условие фильтрации игнорируется, если не выбран столбец «Ср. частота показов»'
                );
            }
            return [];
        },
        'without-inventory-type': function(columns, slices) {
            if (!~slices.indexOf('inventory_type')) {
                return iget2(
                    'b-statistic-filters-editor',
                    'without-inventory-type',
                    'Условие фильтрации игнорируется, если не выбран срез «Тип инвентаря»'
                );
            }
            return [];
        },
        'columns-without-inventory-type': function(columns, slices) {
            if (slices.indexOf('inventory_type') !== -1) {
                return iget2(
                    'b-statistic-filters-editor',
                    'columns-without-inventory-type',
                    'Условие фильтрации игнорируется, если выбран срез «Тип инвентаря»'
                );
            }
            return [];
        },
        hasNonCpmSlices: function(slices) {
            var nonCpmSlices = [
                'tags',
                'contextcond_orig',
                'criterion_type',
                'match_type',
                'retargeting_coef',
                'page_group',
                'page',
                'physical_region',
                'banner_image_type',
                'image_size',
                'content_targeting'
            ];

            return slices.some(function(slice) {
                return !!~nonCpmSlices.indexOf(slice);
            });
        },
        hasNonCpmOutdoorSlices: function(slices) {
            var nonCpmOutdoorSlices = [
                'inventory_type',
                'device_type'
            ];

            return slices.some(function(slice) {
                return !!~nonCpmOutdoorSlices.indexOf(slice);
            });
        },
        'shows-not-supported': function(columns, slices) {
            if (this.hasShowRelatedColumns(columns)) {
                return iget2(
                    'b-statistic-filters-editor',
                    'uslovie-filtracii-ignoriruetsya-esli-vibrani-stolbci-pokazy-ctr-ili-srednaya-poziciya-pokazov',
                    'Условие фильтрации игнорируется, если выбраны столбцы «Показы», «CTR (%)» или «Ср. позиция показа»'
                );
            }
            return [];
        },
        hasShowRelatedColumns: function(columns) {
            var showRelatedColumns = [
                'shows',
                'ctr',
                'fp_shows_avg_pos',
            ];

            return showRelatedColumns.some(function(column) {
                return !!~columns.indexOf(column);
            })
        },
        'auction-wins-not-supported': function(columns) {
            if (~columns.indexOf('auction_wins')) {
                return this.getMetricsColumn('auction_wins');
            }

            return [];
        },
        'served-impressions-not-supported': function(columns) {
            if (~columns.indexOf('served_impressions')) {
                return this.getMetricsColumn('served_impressions');
            }

            return [];
        },
        'uniq-completed-viewers-not-supported': function(columns) {
            if (~columns.indexOf('uniq_completed_viewers')) {
                return this.getMetricsColumn('uniq_completed_viewers');
            }

            return [];
        },
        'imp-reach-rate-not-supported': function(columns) {
            if (~columns.indexOf('imp_reach_rate')) {
                return this.getMetricsColumn('imp_reach_rate');
            }
            return [];
        },
        'auction-win-rate-not-supported': function(columns) {
            if (~columns.indexOf('auction_win_rate')) {
                return this.getMetricsColumn('auction_win_rate');
            }

            return [];
        },
        'auction-hits-not-supported': function(columns) {
            if (~columns.indexOf('auction_hits')) {
                return this.getMetricsColumn('auction_hits');
            }

            return [];
        },
        getMetricsColumn: function(column) {
            return iget2(
                'b-statistic-filters-editor',
                'filters-are-not-supported-for-cpm-metrics',
                'Условие фильтрации игнорируется, если выбран столбец «{Column}»',
                { Column: u['text-store'].get('chart', column) }
            );
        },
        'need-cpm-auction-wins': function(columns, slices) {
            return this.hasNonCpmSlices(slices) && !~columns.indexOf('auction_wins') ?
                 iget2(
                    'b-statistic-filters-editor',
                    'need-cpm-auction-wins2',
                    'Условие фильтрации игнорируется, если не выбран столбец «Выигрыши в аукционах»'
                ) :
                [];
        },
        'need-cpm-auction-hits': function(columns, slices) {
            return this.hasNonCpmSlices(slices) && !~columns.indexOf('auction_hits') ?
                 iget2(
                    'b-statistic-filters-editor',
                    'need-cpm-auction-hits',
                    'Условие фильтрации игнорируется, если не выбран столбец «Участие в аукционах»'
                ) :
                [];
        },
        'need-cpm-auction-win-rate': function(columns, slices) {
            return this.hasNonCpmSlices(slices) && !~columns.indexOf('auction_win_rate') ?
                 iget2(
                    'b-statistic-filters-editor',
                    'need-cpm-auction-win-rate2',
                    'Условие фильтрации игнорируется, если не выбран столбец «Доля выигрышей (%)»'
                ) :
                [];
        },
        'need-cpm-imp-reach-rate': function(columns, slices) {
            return this.hasNonCpmSlices(slices) && !~columns.indexOf('imp_reach_rate') ?
                 iget2(
                    'b-statistic-filters-editor',
                    'need-cpm-imp-reach-rate',
                    'Условие фильтрации игнорируется, если не выбран столбец «SOV (%)»'
                ) :
                [];
        },
        'need-cpm-served-impressions': function(columns, slices) {
            return this.hasNonCpmSlices(slices) && !~columns.indexOf('served_impressions') ?
                 iget2(
                    'b-statistic-filters-editor',
                    'need-cpm-served-impressions',
                    'Условие фильтрации игнорируется, если не выбран столбец «Выходы»'
                ) :
                [];
        },
        'need-cpm-uniq-completed-viewers': function(columns, slices) {
            return (this.hasNonCpmSlices(slices) || this.hasNonCpmOutdoorSlices(slices)) && !~columns.indexOf('uniq_completed_viewers') ?
                iget2(
                    'b-statistic-filters-editor',
                    'need-cpm-uniq-completed-viewers',
                    'Условие фильтрации игнорируется, если не выбран столбец «Достроенный охват»'
                ) :
                [];
        }
    },

    hasExclusionWarnings: function() {
        return !!(this._exclusionWarnings && this._exclusionWarnings.length);
    },

    /**
     * @callback setItemsFunctionCallback
     * @param { { ne: [], eq: [] } } operations
     * @param { { id: string, title: string }[] } selected
     * @param { { id: string, title: string }[] } listItems
     */

    /**
     * Инициализирует асинхронно запрашиваемый саджест для фильтров с множественным выбором
     * @param { Object.<string, {val: string, text: string}[]> } response
     * @param { { ne: [], eq: [] } } operations
     * @param { string } traitName
     * @param {setItemsFunctionCallback} setItemsFunction
     */
    initFilterSuggestItems: function(response, operations, traitName, setItemsFunction) {
        var selected = [],
            mapQueryResponseToFilterSuggestItems = function(trait) {
                return {
                    id: trait.text,
                    title: trait.text
                }
            },
            listItems = (response[traitName] || [])
                .map(mapQueryResponseToFilterSuggestItems)
                .sort(function(firstValue, secondValue) {
                    return firstValue.title.toLowerCase() > secondValue.title.toLowerCase() ? 1 : -1;
                }),
            fillSelectedItems = function(catId) {
                for (var index = 0; index < listItems.length; index++) {
                    if (listItems[index].id == catId) {
                        selected.push(listItems[index]);
                        break;
                    }
                }
            };

        (operations.eq || operations.ne || []).map(fillSelectedItems);

        setItemsFunction(operations, selected, listItems);
    },

    /**
     * Рисует предупреждения внутри фильтра
     * @param {Array} warnings массив из текстов предупреждений
     * @private
     * */
    _updateExclusionWarnings: function(warnings) {
        var warningsElem = this.findElem('filter-warnings');

        BEM.DOM.destruct(warningsElem);

        if (warnings.length) {
            BEM.DOM.append(
                this.domElem,
                BEMHTML.apply(warnings.map(function(warn) {
                    return {
                        block: 'b-statistic-filters-editor',
                        elem: 'filter-warnings',
                        content: warn
                    }
                }))
            );
        }

        return this._exclusionWarnings = warnings;
    },

    /**
     * Проверка на валидность
     * @returns {Boolean}
     */
    isValid: function() {
        return true;
    },

    /**
     * Вызывается при изменении значения в блоках input
     * @private
     */
    _onInputChange: function() { /* Переопределяется в модификаторах элемента */ },

    /**
     * Вызывается при изменении значения в блоках select
     * @private
     */
    _onSelectChange: function() { /* Переопределяется в модификаторах элемента */ },

    /**
     * Вызывается при переключении модификатора compare
     * @private
     */
    _onCompareToggle: function() { /* Переопределяется в модификаторах элемента */ },

    /**
     * Проверяет наличие опций доступных только для сравнения
     * @returns {boolean}
     */
    needCompareWarning: function() {
        /* Переопределяется в модификаторах элемента */
        return false;
    }

}, {

    live: false

});
