block('b-statistic-filters-editor').elem('header').def()(function() {

    return applyCtx({
        block: 'b-page-title',
        mods: { size: 'xs' },
        mix: [{
            block: 'b-statistic-filters-editor',
            elem: 'header'
        }],
        title: {
            block: 'b-statistics-template-list',
            mods: { type: 'stat-filters' },
            mix: [{
                block: 'b-statistic-filters-editor',
                elem: 'dropdown',
                elemMods: { type: 'templates' },
                js: true
            }],
            defaultTitle: iget2('b-statistic-filters-editor', 'filtry-118', 'Фильтры'),
            templates: (this.ctx.templates || []).map(function(item) {
                return {
                    statType: item.stat_type,
                    title: item.name,
                    params: item.data,
                    selected: item.selected,
                    content: [
                        u.escapeHTML(u.hellipCut(item.name, 35, '...')),
                        item.hasCompare && {
                            block: 'b-icon',
                            mods: { 'size-13': 'compare-periods' },
                            mix: { block: 'b-statistic-filters-editor', elem: 'compare-periods-icon' }
                        }
                    ]
                };
            })
        }
    });
});
