BEM.DOM.decl({
    block: 'b-statistic-filters-editor',
    elem: 'row'
}, {

    /**
     * Кэш фильтра
     */
    _filter: null,

    /**
     * Меняет модификатор state
     * @param {String} modVal - новое значение state
     * @returns {BEM}
     */
    toggleState: function(modVal) {
        return this.hasMod('state', modVal) ?
            this.delMod('state') :
            this.setMod('state', modVal);
    },

    getRowParams: function(extraParams) {
        var params = $.extend({}, this.params);

        delete params.uniqId;

        return $.extend({ extraParams: extraParams || {} }, params);
    },

    /**
     * Удаляет фильтр из DOM-дерева
     */
    remove: function() {
        var parent = this.getParent(),
            filterName = this.getMod('filter');

        this.destruct();

        parent.onFilterRemoved(filterName);
    },

    /**
     * Возвращает экземпляр фильтра
     * @returns {BEM}
     */
    getFilter: function() {
        return this._filter || (this._filter = this.elemInstance('filter'));
    }

}, {

});
