block('b-statistic-filters-editor')(

    def()(function() {
        var filters = this.ctx.filters, // Заполненные пользователем фильтры
            data = this.data,
            campaign = data.campaign || {},
            campType = campaign.mediaType,
            currency = ' (' + u.currencies.getName(campaign.currency || data.client_currency) + ')',
            availableCampTypes = data.available_camp_types || [],
            hasDynamicMediaCamp = availableCampTypes.indexOf('performance') != -1,
            isPercOfImpDisabled = u.consts('isPercOfImpDisabled'),
            isUniqCompletedViewersEnabled = this.data.is_feature_uniq_completed_viewers_stat_enabled,
            allowedDialogFeature = !!data.allowed_dialog_feature,
            allowedTurboForSerpWizardFeature = !!(data.features_enabled_for_client &&
                data.features_enabled_for_client.turbo_for_serp_wizard),
            multicardEnabledFeature = data.features_enabled_for_client &&
                (data.features_enabled_for_client.asset_tgo_multicard ||
                    data.features_enabled_for_client.asset_cpm_video_multicard),
            // массив названий доступных фильтров для текущего типа кампании и типа статистики
            availableFilters = this.ctx.availableFilters || [],
            // хэш названий доступных фильтров для текущего типа кампании и типа статистики
            // используется для сортировки filtersByGroups
            availableFiltersHash = this.ctx.availableFilters.reduce(function(acc, c) {
                acc[c] = true;
                return acc;
            }, {}),
            isARP = data.statType === 'ext_phrases', // Additional relevant phrases
            useBanner = campType === 'mcbanner',
            isPostViewAvailable = hasEnabledFeatures('post_view_statistics'),
            externalVals = [].concat(data.FORM.attribution_model || data.attribution_model),
            hiddenForPostViewAttributionsModels = [
                'last_significant_click_cross_device',
                'last_yandex_direct_click_cross_device',
                'first_click',
                'last_click',
                'last_significant_click',
                'last_yandex_direct_click',
                'first_click_cross_device'
            ],
            // структура фильтров для пользователя
            filtersByGroups = [
                {
                    text: iget2('b-statistic-filters-editor', 'kampanii', 'Кампании'),
                    group: [
                        {
                            text: iget2('b-statistic-filters-editor', 'tip', 'Тип'),
                            name: 'campaign_type'
                        },
                        {
                            text: u.consts('rights').enableStatsMultiClientsMode ?
                                iget2('b-statistic-filters-editor', 'no', '№') :
                                iget2('b-statistic-filters-editor', 'no', '№') + ' / ' + iget2('b-statistic-filters-editor', 'nazvanie-116', 'название'),
                            name: 'campaign'
                        },
                        {
                            text: iget2('b-statistic-filters-editor', 'strategiya', 'Стратегия'),
                            name: 'campaign_strategy'
                        },
                        {
                            text: iget2('b-statistic-filters-editor', 'status', 'Статус'),
                            name: 'campaign_status'
                        }
                    ]
                },
                {
                    text: iget2('b-statistic-filters-editor', 'metki', 'Метки'),
                    name: 'tags'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'gruppy-115', 'Группы'),
                    group: [
                        {
                            text: iget2('b-statistic-filters-editor', 'no', '№'),
                            name: 'adgroup_id'
                        },
                        {
                            text: iget2('b-statistic-filters-editor', 'name', 'Название'),
                            name: 'adgroup'
                        },
                        {
                            text: iget2('b-statistic-filters-editor', 'status', 'Статус'),
                            name: 'adgroup_status'
                        }
                    ]
                },
                {
                    text: useBanner ? iget2('b-statistic-filters-editor', 'banner', 'Баннер') : iget2('b-statistic-filters-editor', 'obyavleniya', 'Объявления'),
                    group: [
                        {
                            text: iget2('b-statistic-filters-editor', 'no', '№'),
                            name: 'banner'
                        },
                        {
                            text: iget2('b-statistic-filters-editor', 'status', 'Статус'),
                            name: 'banner_status'
                        },
                        {
                            text: iget2('b-statistic-filters-editor', 'tip', 'Тип'),
                            name: 'banner_type'
                        }
//                      { text: iget('Текст'), name: 'banner_text' } DIRECT-46928 ждем backend
                    ]
                },
                isPostViewAvailable && {
                    text: 'Post-view',
                    name: 'post-view',
                    externalHidden: hiddenForPostViewAttributionsModels,
                    group: u._.compact([
                        {
                            externalHidden: hiddenForPostViewAttributionsModels,
                            text: iget2('b-statistic-filters-editor', 'otkazy', 'Отказы (%)'),
                            name: 'pv_bounce_ratio'
                        },
                        {
                            externalHidden: hiddenForPostViewAttributionsModels,
                            text: iget2('b-statistic-filters-editor', 'glubina-str', 'Глубина (стр.)'),
                            name: 'pv_adepth'
                        },
                        {
                            externalHidden: hiddenForPostViewAttributionsModels,
                            text: iget2('b-statistic-filters-editor', 'konversiya-120', 'Конверсия') + ' (%)',
                            name: 'pv_aconv'
                        },
                        {
                            externalHidden: hiddenForPostViewAttributionsModels,
                            text: iget2('b-statistic-filters-editor', 'kolichestvo-konversiy', 'Количество конверсий'),
                            name: 'pv_agoalnum'
                        },
                        {
                            externalHidden: hiddenForPostViewAttributionsModels,
                            text: iget2('b-statistic-filters-editor', 'cena-celi', 'Цена цели') + currency,
                            name: 'pv_agoalcost'
                        },
                        {
                            externalHidden: hiddenForPostViewAttributionsModels,
                            text: iget2('b-statistic-filters-editor', 'rentabelnost', 'Рентабельность'),
                            name: 'pv_agoalroi'
                        },
                        u.consts('crrStrategyAllowed') && {
                            text: iget2('b-statistic-filters-editor', 'crr', 'Доля рекламных расходов') + ' (%)',
                            name: 'pv_agoalcrr',
                        },
                        {
                            externalHidden: hiddenForPostViewAttributionsModels,
                            text: iget2('b-statistic-filters-editor', 'dohod', 'Доход') + currency,
                            name: 'pv_agoalincome'
                        },
                        {
                            externalHidden: hiddenForPostViewAttributionsModels,
                            text: iget2('b-statistic-filters-editor', 'agoals-profit', 'Прибыль') + currency,
                            name: 'pv_agoals_profit'
                        },
                        {
                            externalHidden: hiddenForPostViewAttributionsModels,
                            text: iget2('b-statistic-filters-editor', 'uroven-vovlechennosti', 'Уровень вовлеченности'),
                            name: 'pv_aprgoodmultigoal'
                        },
                        {
                            externalHidden: hiddenForPostViewAttributionsModels,
                            text: iget2('b-statistic-filters-editor', 'tsena-vovlechenia', 'Цена вовлечения') + currency,
                            name: 'pv_aprgoodmultigoal_cpa'
                        },
                        {
                            externalHidden: hiddenForPostViewAttributionsModels,
                            text: iget2('b-statistic-filters-editor', 'koefficient-vovlechennosti', 'Коэффициент вовлеченности (%)'),
                            name: 'pv_aprgoodmultigoal_conv_rate'
                        },
                        {
                            externalHidden: hiddenForPostViewAttributionsModels,
                            text: iget2('b-statistic-filters-editor', 'avg-time-to-conv', 'Ср. время до конверсии (час.)'),
                            name: 'pv_avg_time_to_conv'
                        }
                    ])
                },
                {
                    text: iget2('b-statistic-filters-editor', 'poiskovyy-zapros', 'Поисковый запрос'),
                    name: 'search_query'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'status-poiskovogo-zaprosa', 'Статус поискового запроса'),
                    name: 'search_query_status'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'tip-usloviya-pokaza', 'Тип условия показа'),
                    name: 'contexttype'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'tip-usloviya-pokaza', 'Тип условия показа'),
                    name: 'contexttype_orig'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'tip-usloviya-pokaza', 'Тип условия показа'),
                    name: 'criterion_type'
                },
                !isARP && {
                    text: iget2('b-statistic-filters-editor', 'status-usloviya-pokaza', 'Статус условия показа'),
                    name: 'ext_phrase_status'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'tekst-frazy', 'Текст фразы'),
                    name: 'phrase'
                },

                // Дополнительная фраза / поисковые запросы
                {
                    text: iget2('b-statistic-filters-editor', 'tip-dopolnitelnoy-frazy', 'Тип дополнительной фразы'),
                    name: 'bm_type'
                },
                {
                    text: isARP ? iget2('b-statistic-filters-editor', 'dopolnitelnaya-fraza', 'Дополнительная фраза') : iget2('b-statistic-filters-editor', 'tekst-frazy', 'Текст фразы'),
                    name: 'phrase_orig'
                },
                isARP && {
                    text: iget2('b-statistic-filters-editor', 'status-dopolnitelnoy-frazy', 'Статус дополнительной фразы'),
                    name: 'ext_phrase_status'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'podobrannaya-fraza', 'Подобранная фраза'),
                    name: 'matched_phrase'
                },
                // для ДО и Смарт-кампаний есть только один тип соответствия - "-", поэтому фильтр для них не показываем
                !/^(dynamic|performance)$/.test(this.campType) && {
                    text: iget2('b-statistic-filters-editor', 'tip-sootvetstviya', 'Тип соответствия'),
                    name: 'match_type'
                },
                hasLoginRights('super_control', 'superreader_control', 'support_control') && {
                    text: iget2('b-statistic-filters-editor', 'no-algoritma-podbora', '№ алгоритма подбора'),
                    name: 'sim_distance'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'usloviya-podbora-auditorii', 'Условия подбора аудитории'),
                    name: 'retargeting'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'interes', 'Интерес'),
                    name: 'rmp_interest'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'korrektirovki', 'Корректировки'),
                    group: [{
                        text: iget2('b-statistic-filters-editor', 'usloviya-podbora', 'Условия подбора'),
                        name: 'retargeting_coef'
                    }]
                },
                {
                    text: iget2('b-statistic-filters-editor', 'usloviya-dinamicheskih-obyavleniy-117', 'Условия динамических объявлений'),
                    name: 'dynamic'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'filtry-118', 'Фильтры'),
                    name: 'performance'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'regiony', 'Регионы'),
                    group: [
                        {
                            text: iget2('b-statistic-filters-editor', 'region-targetinga', 'Регион таргетинга'),
                            name: 'region'
                        },
                        {
                            text: iget2('b-statistic-filters-editor', 'region-mestonahozhdeniya', 'Регион местонахождения'),
                            name: 'physical_region'
                        },
                        {
                            text: iget2('b-statistic-filters-editor', 'region-type', 'Тип соответствия региона'),
                            name: 'region_source'
                        }
                    ]
                },
                {
                    text: iget2('b-statistic-filters-editor', 'ploshchadki', 'Площадки'),
                    group: [
                        {
                            text: iget2('b-statistic-filters-editor', 'tip', 'Тип'),
                            name: 'targettype'
                        },
                        {
                            text: iget2('b-statistic-filters-editor', 'nazvanie', 'Название'),
                            name: 'page'
                        },
                        {
                            text: iget2('b-statistic-filters-editor', 'turbo_page_type-2', 'Турбо-версия'),
                            name: 'turbo_page_type'
                        }
                    ]
                },
                {
                    text: iget2('b-statistic-filters-editor', 'sdelki-nomer-i-name', 'Сделки № / название'),
                    name: 'deal_export_id'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'nazvanie-vneshney-seti', 'Название внешней сети'),
                    name: 'ssp'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'placement-type', 'Вид размещения'),
                    name: 'position'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'mesto-klika', 'Место клика'),
                    name: 'click_place'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'formaty', 'Форматы'),
                    name: 'banner_image_type'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'razmer-izobrazheniya', 'Размер изображения'),
                    name: 'image_size'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'tip-ustroystv', 'Тип устройств'),
                    name: 'device_type'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'tip-operacionnoy-sistemy', 'Тип операционной системы'),
                    name: 'detailed_device_type'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'tip-svyazi', 'Тип связи'),
                    name: 'connection_type'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'pol', 'Пол'),
                    name: 'gender'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'semantic-correspondence-type', 'Категория таргетинга'),
                    name: 'targeting_category'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'prisma-income-grade', 'Уровень платежеспособности'),
                    name: 'prisma_income_grade'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'vozrast', 'Возраст'),
                    name: 'age'
                },
                {
                    text: iget2('i-utils', 'client-id', 'Идентификатор клиента'),
                    name: 'client_id'
                },
                {
                    text: iget2('i-utils', 'product_name', 'Название продукта'),
                    name: 'internal_product_name'
                },
                {
                    text: iget2('i-utils', 'place-id', 'Номер плейса'),
                    name: 'place_id'
                },
                {
                    text: iget2('i-utils', 'place-description', 'Описание плейса'),
                    name: 'place_description'
                },
                {
                    text: iget2('i-utils', 'operating-system', 'Операционная система'),
                    name: 'operating_system'
                },
                {
                    text: iget2('i-utils', 'browser', 'Браузер'),
                    name: 'browser'
                },
                {
                    text: iget2('i-utils', 'page-id', 'Номер пейджа'),
                    name: 'page_id'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'template-id', 'Шаблон'),
                    name: 'template_id'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'cel', 'Цель'),
                    name: 'goal_id',
                    unavailable: data.failed_to_fetch_metrika == 1,
                    title: iget2('b-statistic-filters-editor', 'metrika-unavailable', 'Фильтрация по этому условию временно недоступна')
                },
                {
                    text: iget2('b-statistic-filters-editor', 'pokazy', 'Показы'),
                    name: 'shows'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'avg-nshow', 'Заметность показов (%)'),
                    name: 'avg_nshow'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'eshows', 'Взвешенные показы'),
                    name: 'eshows'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'kliki', 'Клики'),
                    name: 'clicks'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'ctr', 'CTR') + ' (%)',
                    name: 'ctr'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'wctr', 'wCTR') + ' (%)',
                    name: 'ectr'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'rashod-vsego', 'Расход всего') + currency,
                    name: 'sum'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'sr-cena-klika', 'Ср. цена клика') + currency,
                    name: 'av_sum'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'video-mute', 'Клики выключить звук'),
                    name: 'video_mute'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'video-unmute', 'Клики включить звук'),
                    name: 'video_unmute'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'srednia-stavka-za-klik', 'Ср. ставка за клик') + currency,
                    name: 'avg_bid'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'sr-cena-tys-pokazov', 'Ср. цена тыс. показов') + currency,
                    name: 'avg_cpm'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'cpcc-completed-view', 'Ср. цена досмотра 100% ролика') + currency,
                    name: 'cpcv'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'sr-poziciya-pokaza', 'Ср. позиция показа'),
                    name: 'fp_shows_avg_pos'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'avg_x', 'Ср. объём трафика'),
                    name: 'avg_x'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'sr-poziciya-klika', 'Ср. позиция клика'),
                    name: 'fp_clicks_avg_pos'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'dolya-vyigryshey-po-pokazam', 'Доля выигрышей по показам (%)'),
                    name: 'cpm_winrate'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'ohvat', 'Охват'),
                    name: 'uniq_viewers'
                },
                isUniqCompletedViewersEnabled && {
                    text: iget2('b-statistic-filters-editor', 'uniq-completed-viewers', 'Достроенный охват'),
                    name: 'uniq_completed_viewers',
                },
                {
                    text: iget2('b-statistic-filters-editor', 'vykuplennyh-unikalnyh-polzovateley', '% выкупленных уникальных пользователей'),
                    name: 'uniq_users_winrate'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'sr-chastota-pokazov', 'Ср. частота показов'),
                    name: 'avg_view_freq'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'clip-first-quartile', 'Проигрывание 25% ролика'),
                    name: 'video_first_quartile'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'clip-midpoint', 'Проигрывание 50% ролика'),
                    name: 'video_midpoint'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'clip-third-quartile', 'Проигрывание 75% ролика'),
                    name: 'video_third_quartile'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'clip-complete', 'Проигрывание 100% ролика'),
                    name: 'video_complete'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'clip-true-view', 'Просмотры'),
                    name: 'video_true_view'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'clip-avg-true-view-cost', 'Ср. цена просмотра ролика') + currency,
                    name: 'video_avg_true_view_cost'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'clip-first-quartile-rate', 'Доля проигрываний 25% ролика'),
                    name: 'video_first_quartile_rate'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'clip-midpoint-rate', 'Доля проигрываний 50% ролика'),
                    name: 'video_midpoint_rate'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'clip-third-quartile-rate', 'Доля проигрываний 75% ролика'),
                    name: 'video_third_quartile_rate'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'clip-complete-rate', 'Доля проигрываний 100% ролика'),
                    name: 'video_complete_rate'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'avg-nshow-complete', 'Заметность досмотров (%)'),
                    name: 'avg_nshow_complete'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'clip-true-view-rate', 'Доля просмотров (%)'),
                    name: 'video_true_view_rate'
                },
                !isPercOfImpDisabled && {
                    text: iget2('b-statistic-filters-editor', 'procent-poluchennyh-pokazov-119', 'Процент полученных показов') + ' (%)',
                    name: 'winrate'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'otkazy', 'Отказы (%)'),
                    name: 'bounce_ratio'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'glubina-str', 'Глубина (стр.)'),
                    name: 'adepth'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'konversiya-120', 'Конверсия') + ' (%)',
                    name: 'aconv'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'kolichestvo-konversiy', 'Количество конверсий'),
                    name: 'agoalnum'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'cena-celi', 'Цена цели') + currency,
                    name: 'agoalcost'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'rentabelnost', 'Рентабельность'),
                    name: 'agoalroi'
                },
                u.consts('crrStrategyAllowed') && {
                    text: iget2('b-statistic-filters-editor', 'crr', 'Доля рекламных расходов') + ' (%)',
                    name: 'agoalcrr',
                },
                {
                    text: iget2('b-statistic-filters-editor', 'dohod', 'Доход') + currency,
                    name: 'agoalincome'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'agoals-profit', 'Прибыль') + currency,
                    name: 'agoals_profit'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'uroven-vovlechennosti', 'Уровень вовлеченности'),
                    name: 'aprgoodmultigoal'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'tsena-vovlechenia', 'Цена вовлечения') + currency,
                    name: 'aprgoodmultigoal_cpa'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'koefficient-vovlechennosti', 'Коэффициент вовлеченности (%)'),
                    name: 'aprgoodmultigoal_conv_rate'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'ab-segments', 'Эксперименты'),
                    name: 'ab_segment',
                    unavailable: data.failed_to_fetch_audience == 1,
                    title: iget2('b-statistic-filters-editor', 'metrika-unnavailable', 'Фильтрация по этому условию временно недоступна')
                },
                {
                    text: iget2('b-statistic-filters-editor', 'avg-time-to-conv', 'Ср. время до конверсии (час.)'),
                    name: 'avg_time_to_conv'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'auction-win-rate2', 'Доля выигрышей (%)'),
                    name: 'auction_win_rate',
                },
                {
                    text: iget2('b-statistic-filters-editor', 'imp-reach-rate', 'SOV (%)'),
                    name: 'imp_reach_rate'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'auction-wins2', 'Выигрыши в аукционах'),
                    name: 'auction_wins',
                },
                {
                    text: iget2('b-statistic-filters-editor', 'auction-hits', 'Участие в аукционах'),
                    name: 'auction_hits',
                },
                {
                    text: iget2('b-statistic-filters-editor', 'served_impressions', 'Выходы'),
                    name: 'served_impressions',
                },
                {
                    text: iget2('b-statistic-filters-editor', 'inventory-type', 'Тип инвентаря'),
                    name: 'inventory_type'
                },
                {
                    text: campType === 'cpm_price' ?
                        iget2('b-statistic-filters-editor', 'ad-site-clicks-cpm_price', 'Открытие раскрывающегося блока') :
                        iget2('b-statistic-filters-editor', 'ad-site-clicks-cpm_banner', 'Показ пэкшота'),
                    name: 'ad_site_clicks'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'viewable-impressions-mrc', 'Видимые показы, стандарт MRC'),
                    name: 'viewable_impressions_mrc'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'nonviewable-impressions-mrc', 'Невидимые показы, стандарт MRC'),
                    name: 'nonviewable_impressions_mrc'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'undetermined-impressions-mrc', 'Неустановленные показы, стандарт MRC'),
                    name: 'undetermined_impressions_mrc'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'measured-rate-mrc', 'Доля измеряемых показов, стандарт MRC (%)'),
                    name: 'measured_rate_mrc'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'viewable-rate-mrc', 'Доля видимых показов, стандарт MRC (%)'),
                    name: 'viewable_rate_mrc'
                }
            ].filter(function(item) {
                if (!item) return false;

                if (u._.isArray(item.group)) {
                    item.group = item.group.filter(function(groupItem) {
                        return availableFiltersHash[groupItem.name];
                    });

                    return !!item.group.length;
                } else if (item.name) {
                    return availableFiltersHash[item.name];
                }
            }),

            // по filterName обязательно хранит расположение фильтра(path) и его серверное название(backendName),                                                                                   v
            // может хранить некоторые дополнительные параметры конкретного фильтров
            extraParams = {
                'goal-id': {
                    goals: this.ctx.goalsList || []
                },
                'banner-image-type': {
                    mediaType: campaign.mediaType,
                    availableCampTypes: data.available_camp_types,
                    isMulticardEnabled: multicardEnabledFeature
                },
                campaign: {
                    campaigns: (data.campaigns_list || []).map(function(campaign) {
                        return {
                            id: campaign.cid,
                            title: campaign.name + ' (' + campaign.cid + ')',
                            favorite: campaign.is_favorite
                        };
                    })
                },
                'deal-export-id': {
                    deals: (data.deals_list || []).map(function(deal) {
                        return {
                            id: deal.id,
                            title: deal.name + ' (' + deal.id + ')'
                        };
                    })
                },
                'campaign-type': {
                    campTypes: availableCampTypes,
                    currentCampType: this.campType,
                    statType: data.statType
                },
                'campaign-strategy': {
                    campTypes: availableCampTypes
                },
                contexttype: {
                    campTypes: availableCampTypes,
                    campType: this.campType,
                    statType: data.statType
                },
                'contexttype-orig': {
                    campTypes: availableCampTypes,
                    campType: this.campType,
                    statType: data.statType
                },
                'click-place': {
                    hasDynamicMediaCamp: hasDynamicMediaCamp,
                    allowedDialogFeature: allowedDialogFeature,
                    allowedTurboForSerpWizardFeature: allowedTurboForSerpWizardFeature
                },
                retargeting: {
                    retargetings: (data.retargetings_list || []).map(function(retargeting) {
                        return {
                            id: retargeting.ret_cond_id,
                            title: retargeting.condition_name
                        };
                    })
                },
                'rmp-interest': {
                    interests: (data.rmp_interests_list || []).map(function(interest) {
                        return {
                            id: interest.ret_cond_id,
                            title: interest.condition_name
                        };
                    })
                },
                dynamic: {
                    conditions: (data.dynamic_cond_list || []).map(function(condition) {
                        return {
                            id: condition.id,
                            title: condition.name
                        };
                    })
                },
                performance: {
                    filters: (data.performance_filter_list || []).map(function(filter) {
                        return {
                            id: filter.id,
                            title: filter.name
                        };
                    })
                },
                tags: {

                    tags: (data.tags_list || []).map(function(tag) {
                        return {
                            id: u._.uniqueId('tag-'),
                            title: tag
                        };
                    })
                },
                'image-size': {
                    formats: (data.banner_formats || []).map(function(format) {
                        return {
                            id: format,
                            title: format === '0x0' ? iget2('b-dynamic-media-creative', 'adaptivnii', 'Адаптивный') : format
                        };
                    })
                },
                shows: {
                    campType: this.campType
                },
                eshows: {
                    campType: this.campType
                },
                ctr: {
                    campType: this.campType
                },
                ectr: {
                    campType: this.campType
                },
                'fp-shows-avg-pos': {
                    campType: this.campType
                },
                'avg-x': {
                    campType: this.campType
                },
                'retargeting-coef': {
                    retargetings: (data.retargeting_coefs_list || []).map(function(retargeting) {
                        return {
                            id: retargeting.ret_cond_id,
                            title: retargeting.condition_name
                        };
                    })
                },
                'ab-segment': {
                    sections: data.ab_section_list || []
                },
                'banner-type': {
                    campType: this.campType,
                    statType: data.statType
                }
            },
            exclusionsRules = {},
            // добавляет данные в filtersByGroups
            prepareFilters = function(items, path) {
                return items.map(function(item) {
                    var itemPath = [].concat(path || [], [item.text]);

                    // У группы тоже может быть name и externalHidden
                    if (item.name && item.externalHidden) {
                        if (!exclusionsRules[item.name]) {
                            exclusionsRules[item.name] = {
                                externalHidden: []
                            };
                        }

                        var rule = exclusionsRules[item.name];

                        if (item.externalHidden) {
                            [].push.apply(rule.externalHidden, item.externalHidden);
                        }

                        if (item.externalExpand) {
                            [].push.apply(rule.externalExpand, item.externalExpand);
                        }
                    }

                    if (item.group) {
                        return prepareFilters(item.group, itemPath);
                    }

                    var bemName = u.beminize(item.name);

                    extraParams[bemName] || (extraParams[bemName] = {});
                    extraParams[bemName].path = itemPath;
                    extraParams[bemName].backendName = item.name;

                    if (filters[item.name]) {
                        item.operations = filters[item.name];
                    }

                    return item;
                });
            };

        prepareFilters(filtersByGroups);

        // eugengantz / DIRECT-56422
        this.ctx.filters = u._.pick(this.ctx.filters, availableFilters);

        return applyNext({
            externalVals: externalVals,
            filtersByGroups: filtersByGroups, // структура фильтров с данными
            exclusionsRules: exclusionsRules,
            calculatedExclusion: u['b-statistic-filters-editor'].calculateExclusion(filtersByGroups, exclusionsRules, externalVals),
            extraParams: extraParams,
            availableFilters: availableFilters,
            isChangeManualStrategyName: Boolean(this.data.has_change_name_bid_optimization)
        });
    }),

    addJs()(function() {
        return {
            externalVals: this.externalVals,
            exclusionsRules: this.exclusionsRules,
            calculatedExclusion: this.calculatedExclusion,
            extraParams: this.extraParams,
            cid: this.data.campaign && this.data.FORM.cid,
            statType: this.data.statType,
            singleCamp: this.data.campaign && this.data.FORM.single_camp,
            isChangeManualStrategyName: Boolean(this.data.has_change_name_bid_optimization)
        };
    }),

    content()(function() {
        var isChangeManualStrategyName = Boolean(this.data.has_change_name_bid_optimization);

        return [
            {
                elem: 'header',
                templates: this.ctx.templates
            },
            {
                elem: 'table',
                content: (function() {
                    var _this = this;
                    return Object.keys(_this.ctx.filters)
                        .reduce(function(prev, name) {
                            var replacedName = u.beminize(name);

                            if (!!~_this.availableFilters.indexOf(name) && _this.extraParams[replacedName]) {
                                return prev.concat({
                                    elem: 'row',
                                    elemMods: {
                                        filter: replacedName
                                    },
                                    filter: {
                                        name: replacedName,
                                        operations: _this.ctx.filters[name] || {},
                                        extraParams: _this.extraParams[replacedName]
                                    },
                                    index: prev.length + 1,
                                    isChangeManualStrategyName: isChangeManualStrategyName
                                });
                            }

                            return prev;
                        }, []);
                }).call(this)
            },
            {
                elem: 'dropdown',
                elemMods: {
                    type: 'filters-chooser'
                },
                filtersByGroups: this.filtersByGroups,
                calculatedExclusion: this.calculatedExclusion
            },
            {
                elem: 'dropdown',
                elemMods: {
                    type: 'save-template'
                },
                filters: this.ctx.filters
            },
            (this.data.failed_to_fetch_metrika == 1 || this.data.failed_to_fetch_audience == 1) && {
                block: 'b-notice',
                mix: {
                    block: 'b-statistics-form',
                    elem: 'metrika-warning'
                },
                mods: {
                    theme: 'inline-notification'
                },
                content: iget2('b-statistics-form', 'metrika-filters-warning', 'Некоторые условия фильтрации временно недоступны. Мы делаем все для их скорейшего возвращения')
            },
        ];
    })
);
