BEM.DOM.decl('b-statistic-filters-editor', {

    onSetMod: {

        js: function() {
            this._slices || (this._slices = []);
            this._columns || (this._columns = []);
            this._externalVals || (this._externalVals = this.params.externalVals || []);

            this._currentTemplate = this.getFiltersData();
        },

        compare: function(modName, modVal) {
            this.trigger('compare', modVal);
        }

    },

    /**
     * Меняет расширенние данные для колонок и срезов
     * @param {String[]} vals
     */
    setExternalVals: function(vals) {
        this._externalVals = vals;
        this._recalculate.call(this);
    },

    _recalculate: function() {
        var chooser = this.getChooser(),
            flatTree = chooser.getFlatTree(),
            exclusions = this._getExclusions();

        chooser.setStates(exclusions);

        var rows = [].concat(this.elemInstances('row')).reduce(function(acc, row) {
            var params = row.getRowParams();

            if (params && params.name) {
                acc[params.name] = { row: row, params: params };
            }

            return acc;
        }, {});

        [].concat(flatTree.items, flatTree.groups).forEach(function(obj) {
            var name = obj.params.name,
                rowData = name && rows[u.beminize(name)];

            if (rowData && exclusions.hidden[name]) {
                rowData.row.remove();
            }
        });
    },

    _getExclusions: function() {
        var chooser = this.getChooser(),
            flatTree = chooser && chooser.getFlatTree();

        return u['b-statistic-filters-editor'].calculateExclusion(
            [].concat(flatTree.groups, flatTree.items).map(function(obj) {
                return obj.params;
            }),
            this.params.exclusionsRules,
            this._externalVals
        );
    },

    /**
     * Возвращает блок со списком фильтров
     * @returns {BEM}
     */
    getChooser: function() {
        if (!this._chooser) {
            var dropdown = this.findBlockInside('dropdown'),
                popup = dropdown && dropdown.getPopup(),
                chooser = popup && popup.findBlockInside('b-chooser');

            this._chooser = chooser;
        }

        return this._chooser;
    },

    /**
     * Проверяет наличие фильтра среди выбранных
     * @param {String} name - имя фильтра
     * @returns {Boolean}
     */
    hasFilter: function(name) {
        return !!this.findElem('filter', 'type', name).length;
    },

    /**
     * Возвращает данные по всем фильтрам
     * @param {Object|undefined} ignoreExclusions - список фильтров, по которым надо игнорировать exclusion
     * @returns {Object}
     */
    getFiltersData: function(ignoreExclusions) {
        return this.elemInstances('filter').reduce(function(filtersData, instance) {
            var filterData = instance.getData(),
                filterName = filterData && Object.keys(filterData)[0],
                clientToServerNamesMap = u['b-statistics-form'].clientToServerStatKeyNamesMap

            // Некоторые названия фильтров нужно заменить перед отправкой на сервер - DIRECT-123137
            if (clientToServerNamesMap[filterName]) {
                var mappedFilterName = clientToServerNamesMap[filterName],
                    mappedFilterData = {};

                mappedFilterData[mappedFilterName] = filterData[filterName]

                filterData = mappedFilterData;
                filterName = mappedFilterName;
            }

            var allowFilter = filterData && (ignoreExclusions || {})[filterName];

            if (filterData && (allowFilter || !instance.hasExclusionWarnings())) {
                u._.extend(filtersData, filterData);
            }

            return filtersData;
        }, {});
    },

    /**
     * Строит новый фильтр и добавляет его в конец списка
     * @param {Object} data
     *  @param {String} data.name - имя фильтра
     *  @param {Object} [data.operations] - настройки фильтра
     * @returns {BEM}
     */
    addFilter: function(data) {
        if (this.hasFilter(data.name)) {
            return this;
        }

        BEM.DOM.append(this.elem('table'), BEMHTML.apply({
            block: 'b-statistic-filters-editor',
            elem: 'row',
            elemMods: { filter: data.name },
            filter: {
                name: data.name,
                operations: data.operations || {},
                extraParams: this.params.extraParams[data.name]
            },
            path: this._getPath(data.name),
            index: this.getFiltersCount() + 1,
            isChangeManualStrategyName: this.params.isChangeManualStrategyName
        }));

        this.elemInstance('filter', 'type', data.name)
            .exclusionWarnings(this._columns, this._slices); // TODO перенести в onSetMod фильтра

        return this.trigger('add', { name: data.name });
    },

    /**
     * Возвращает количество выбранных фильтров
     * @returns {Number}
     */
    getFiltersCount: function() {
        return this.findElem('row', 'filter').length;
    },

    /**
     * Триггерит событие remove после удаления фильтра и обновляет номера строк
     * @param {String} filterName - имя фильтра
     * @returns {BEM}
     */
    onFilterRemoved: function(filterName) {
        this._updateFiltersIndexes()
            .getDropdown('filters-chooser').uncheckFilter(filterName);

        return this.trigger('remove', { name: filterName });
    },

    /**
     * Обновляет номера строк с фильтрами
     * @returns {BEM}
     * @private
     */
    _updateFiltersIndexes: function() {
        this.findElem('cell', 'type', 'index').each(function(index, cell) {
            $(cell).text(++index + '.');
        });

        return this;
    },

    /**
     * Возвращает true, если в фильтрах содержаться данные для «Сравнения периодов»
     * @returns {Boolean}
     */
    needCompareWarning: function() {
        return this.elemInstances('filter').some(function(filter) {
            return filter.needCompareWarning();
        });
    },

    /**
     * Хранилище dropdown
     */
    _dropdowns: null,

    /**
     * Находит и возвращает dropdown
     * @param {String} type - тип dropdown
     * @returns {BEM}
     */
    getDropdown: function(type) {
        this._dropdowns || (this._dropdowns = {});

        return this._dropdowns[type] || (this._dropdowns[type] = this.elemInstance('dropdown', 'type', type));
    },

    _columns: null,

    _slices: null,

    checkExclusion: function(columns, slices) {
        this._columns = columns;
        this._slices = slices;

        this.elemInstances('filter')
            .forEach(function(filter) {
                filter.exclusionWarnings(columns, slices);
            });
    },

    /**
     * Возвращает массив в виде ['group', 'filter']
     * @param {String} name - имя фильтра
     * @returns {Array}
     * @private
     */
    _getPath: function(name) {
        return this.params.extraParams[name].path;
    },

    /**
     * Удаляет все фильтры, затем строит на их месте новые
     * @param {Object} filters
     * @param {Boolean} isResetTemplate
     * @returns {BEM}
     */
    fill: function(filters, isResetTemplate) {
        this.elemInstances('row').forEach(function(row) {
            row.remove();
        });

        Object.keys(filters).forEach(function(name) {
            var filterName = u.beminize(name);

            this.addFilter({
                name: filterName,
                operations: filters[name]
            });

            this.getDropdown('filters-chooser').checkFilter(filterName);
        }, this);

        this.trigger('fill', {
            needCompare: u['b-statistic-filters-editor'].isCompareTemplate(filters),
            isResetTemplate: isResetTemplate
        });

        this._currentTemplate = this.getFiltersData();

        return this;
    },

    /**
     * Данные выбранного шаблона
     */
    _currentTemplate: false,

    /**
     * Проверяет вносились изменения в шаблон или нет
     * @returns {boolean}
     */
    isTemplateChanged: function() {
        return this._currentTemplate && !u._.isEqual(this._currentTemplate, this.getFiltersData());
    },

    /**
     * Проверяет данные на наличие ошибок
     * @returns {boolean}
     */
    isValid: function() {
        var isValid = true;

        this.elemInstances('filter').forEach(function(filter) {
            isValid && (isValid = filter.isValid());
        });

        return isValid;
    }

}, {

    live: function() {

        this.liveInitOnBlockInsideEvent('template.save', 'b-statistic-filters-editor__dropdown', function(e, data) {
            this._currentTemplate = data.filters;
        })
            .liveInitOnBlockInsideEvent('change', 'b-statistic-filters-editor__filter', function(e, data) {
                if (this.isValid()) {
                    this.getDropdown('save-template')
                        .getTemplateSaving()
                        .enableButton('switcher');
                } else {
                    this.getDropdown('save-template')
                        .getTemplateSaving()
                        .disableButton('switcher');
                }

                this.trigger('change', data);
            });

        return true;

    }

});
