#b-statistic-filters-editor

Блок предназначен для работы с фильтрами.
Он обеспечивает возможность создания, редактирования списка фильтров,
а так же сохранение их в шаблоны.
[Требования, задачи, взаимодействие с сервером](https://wiki.yandex-team.ru/users/sosnina/annasosnina/mol/)

#Структура элементов блока

* `row` - содержит общий шаблон строки фильтра: номер, расположение, инпуты, элементы удаления
* `filter` - отвечает за логику конкретного фильтра. По модификатору `type` содержаться всевозможные шаблоны
* `control` - шаблоны контролов используемых в элементе `filter`
* `dropdown` - три модификатора `type`:

    * `filters-chooser` - предоставляет список возможных фильтров. Построить список помогает `b-chooser`
    * `save-template` - его задача получить имя шаблона, набор фильтров и отправить эти данные на сервер. Содержит в себе блок `b-statistics-template-saving`.
    * `templates` - Работает с списком шаблонов: добавление/загрузка/удаление. Содержит в себе `b-statistics-template-list`
* `table` - тэг таблицы и стили
* `header` - стили для заголовка
* `cell` - тэг ячейки и стили. Модификатор `type` `actions` - шаблон ячейки с кнопками удаления.
* `button` - стили кнопок и логика их поведения

#Добавление нового фильтра
Для примера мы ходим добавить фильтр «Какой-то фильтр»

1. На странице [Взаимодействие с интерфейсом](https://wiki.yandex-team.ru/direkt/technicaldesign/masterotchetovnaakkaunt/) найти формат данных и серверное название фильтра «Какой-то фильтр» это `some_filter`. Если его нет, то попросить серверсайдника добавить.
2. Файл `b-statistic-filters-editor.bemtree.xjst` в массив `filtersByGroups` дописываем:
`{ text: iget('Какой-то фильтр'), name: 'some_filter' }`
если фильтру нужны какие-то дополнительные серверные параметры то в хэш `extraParams` по названию фильтра добавляем их. В `extraParams` пишем серверное название фильтра в bem нотации.
3. Создаем новый модификатор `type` для фильтра в bem нотации `b-statistic-filters-editor__filter_type_some-filter.bemhtml`:

```
block b-statistic-filters-editor, elem filter, elemMod type some-filter {

    // выбрать существующий или добавить новый get-data-from
    // модификатор фильтра описывающий логику получения данных из фильтра
    // перед отправкой на сервер
    default: applyNext(this.ctx.elemMods['get-data-from'] = 'multiselect')

    content: {
        // парамерты выставленые пользователем
        this.ctx.operations

        // дополнительные парамерты с сервера
        this.ctx.extraParams

        return {
            block: 'b-badges-multiselect',
            items: [{ id: 1, title: 'Текст' }]
        }
    }

}
```

4. Добавить новые модификаторы `type` и `get-data-from` фильтра в `b-statistic-filters-editor__row.deps.js`

#Фильтры:

##Числовые
Описаны в `b-statistic-filters-editor__filter_type.*`
Дизейбл селектов в числовых фильтрах устроен так, что дает выбрать только возможные комбинации:

 * «меньше»
 * «больше»
 * «меньше» и «больше»
 * «равно»

В режиме «Сравнения периодов» добавляются селекты периодов, для каждого типа периода также работают только перечисленные выше комбинации.

##Регионы(Хак)
`b-regions` написан в `.bemtree.xjst`, поэтому он единственный фильтр которой мы не строим на клиенте. Хак заключается в перемещении кнопки «уточнить», отвечающей за открытие попапа.
