u.register({
    'b-statistic-filters-editor': {

        suffixes: ['a', 'b', 'delta', 'absdelta'],

        /**
         * Перекладывает фильтры c суффиксами
         * принимает:
         * {
         *     shows_a: { eq: 1 },
         *     shows_b: { eq: 1 }
         * }
         * возвращает:
         * {
         *     shows: {
         *         a: { eq: 1 },
         *         b: { eq: 1 }
         *     }
         * }
         * @param {Object} serverFilters
         * @returns {Object}
         */
        fromServer: function(serverFilters) {
            var suffixes = this.suffixes;

            return u._.keys(serverFilters).reduce(function(acc, serverKey) {
                var splitedKey = serverKey.split('_'),
                    suffix = splitedKey.slice(-1)[0],
                    isSuffix = suffixes.indexOf(suffix) != -1,
                    value = serverFilters[serverKey],
                    withoutSuffix;

                if (isSuffix) {
                    withoutSuffix = splitedKey.slice(0, -1).join('_');

                    withoutSuffix = u['b-statistics-form'].serverToClientStatKeyNamesMap[withoutSuffix] || withoutSuffix

                    acc[withoutSuffix] || (acc[withoutSuffix] = {});
                    acc[withoutSuffix][suffix] = value;
                } else {
                    serverKey = u['b-statistics-form'].serverToClientStatKeyNamesMap[serverKey] || serverKey
                    acc[serverKey] = value;
                }

                return acc;
            }, {});
        },

        /**
         * Перекладывает фильтры c суффиксами
         * принимает:
         * {
         *     shows: {
         *         a: { eq: 1 },
         *         b: { eq: 1 }
         *     }
         * }
         * возвращает:
         * {
         *     shows_a: { eq: 1 },
         *     shows_b: { eq: 1 }
         * }
         * @param {Object} filters
         * @returns {Object}
         */
        toServer: function(filters) {
            var suffixes = this.suffixes;

            return u._.keys(filters).reduce(function(acc, key) {
                var ratios = u._.keys(filters[key]),
                    hasSuffix = ratios.some(function(ratio) {
                        return suffixes.indexOf(ratio) != -1;
                    });

                if (hasSuffix) {
                    ratios.forEach(function(suffix) {
                        acc[key + '_' + suffix] = filters[key][suffix];
                    });
                } else {
                    acc[key] = filters[key];
                }

                return acc;
            }, {});
        },

        /**
         * Перекладывает фильтры для GET запроса
         * https://wiki.yandex-team.ru/direkt/technicaldesign/masterotchetovnaakkaunt/
         * принимает:
         * {
         *     shows: {
         *         a: { eq: 1 },
         *         b: { eq: 1 }
         *     }
         * }
         * возвращает:
         * {
         *     fl_shows_a__eq: 1,
         *     fl_shows_b__eq: 1
         * }
         * @param {Object} filters
         * @returns {Object}
         */
        toServerGetRequest: function(filters) {
            var serverFilters = this.toServer(filters),
                result = {};

            u._.keys(serverFilters).forEach(function(name) {
                u._.keys(serverFilters[name]).forEach(function(operation) {
                    if (Array.isArray(serverFilters[name][operation])) {
                        result['fl_' + name + '__' + operation + '[]'] = serverFilters[name][operation].join(',');
                    } else {
                        result['fl_' + name + '__' + operation] = serverFilters[name][operation];
                    }
                });
            });

            return result;
        },

        /**
         * Возвращает true, если в data содержаться фильтры предназначенные для «Сравнения периодов»
         * @param {Object} data
         * @returns {Boolean}
         */
        isCompareTemplate: function(data) {
            return u._.keys(data).some(function(key) {
                return this.suffixes.some(function(suffix) {
                    return !!data[key][suffix];
                });
            }, this);
        },

        /**
         * Исходя из выбранных значений и правил вычисляет пункты состояние которых необходимо поменять
         * @typedef {{ externalHidden?: string[]; name?: string; text: string; group?: FilterGroupStat; }} FilterGroupStat
         * @param {FilterGroupStat} vals список выбранных значений
         * @param {Object} rules объект с правилами взаимодействия между столбцами/срезами
         * @param {string[]} externalVals
         * @returns {{ hidden: Record<string, boolean> }}
         */
        calculateExclusion: function(vals, rules, externalVals) {
            var result = vals.filter(function(item) {
                return Boolean(item.name);
            }).reduce(function(acc, val) {
                var rule = rules[val.name];

                if (!rule) {
                    return acc;
                }

                if (rule.externalHidden) {
                    acc.hidden[val.name] = rule.externalHidden.some(function(eH) {
                        return !!~externalVals.indexOf(eH);
                    });
                }

                return acc;
            }, { hidden: {} });

            return result;
        }

    }
});
